﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.BMService;
using BMS.Facade.Data;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete
{
    public class BedUnavailableDal
    {
        private IList<BedUnavailableInfo> bedUnavailables;

        private readonly VistaSite site;

        public BedUnavailableDal(VistaSite site)
        {
            this.site = site;
        }

        public BedUnavailableInfo Get(II bedId)
        {
            if (bedUnavailables == null)
                bedUnavailables = BMSFactory.BedManagerQueryClientWindows.FilterBedUnavailableInfo(site.Id);

            return bedUnavailables.FirstOrDefault(b => b.BedId.extension.Equals(bedId.extension, StringComparison.InvariantCultureIgnoreCase));
        }
    }
}
