﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.VistaWorker2.Writer.Implementation.Concrete;


namespace BMS.VistaWorker2.Writer
{
    /// <summary>
    /// Interface implemented by entity writer used to write changes for entity T to the data source.
    /// </summary>
    /// <typeparam name="T">The entity type.</typeparam>
    public interface IEntityWriter<T> : IDisposable
    {
        /// <summary>
        /// Inserts the specified entity.
        /// </summary>
        /// <param name="entity">The entity to insert.</param>
        /// <exception cref="WriterConnectionLostException">Connection to writer has been lost.</exception>
        void Insert(T entity);

        /// <summary>
        /// Updates the specified entity.
        /// </summary>
        /// <param name="entity">The entity to update.</param>
        /// <exception cref="WriterConnectionLostException">Connection to writer has been lost.</exception>
        bool Update(T entity);

        /// <summary>
        /// Deletes the specified entity.
        /// </summary>
        /// <param name="entity">The entity to delete.</param>
        /// <exception cref="WriterConnectionLostException">Connection to writer has been lost.</exception>
        void Delete(T entity);

        /// <summary>
        /// Gets or sets the log checker.
        /// </summary>
        /// <value>
        /// The log checker.
        /// </value>
        IVistaIntegrationLogChecker LogChecker { get; set; }


    }
}
