﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaWorker2.Writer.Exceptions
{

    /// <summary>
    /// Indicates that writer occured an exception when processing an entity.
    /// </summary>
    [Serializable]
    public class WriterException : Exception
    {
        public object Entity { get; private set; }

        /// <summary>
        /// Initializes a new instance of the <see cref="WriterException"/> class with a specified error message.
        /// </summary>
        /// <param name="entity">The entity.</param>
        /// <param name="message">The message that describes the error.</param>
        /// <param name="stopProcessing">if set to <c>true</c> [stop processing].</param>
        public WriterException(object entity, string message) :
            base(message)
        {
            Entity = entity;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WriterException"/> class.
        /// </summary>
        /// <param name="entity">The entity.</param>
        /// <param name="message">The message.</param>
        /// <param name="innerException">The inner exception.</param>
        /// <param name="stopProcessing">if set to <c>true</c> [stop processing].</param>
        public WriterException(object entity, string message, Exception innerException)
            : base(message, innerException)
        {
            Entity = entity;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="WriterException"/> class with serialized data.
        /// </summary>
        /// <param name="info">The <see cref="T:System.Runtime.Serialization.SerializationInfo"/> that holds the serialized object data about the exception being thrown.</param>
        /// <param name="context">The <see cref="T:System.Runtime.Serialization.StreamingContext"/> that contains contextual information about the source or destination.</param>
        protected WriterException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }

    }
}
