﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;

namespace BMS.VistaWorker.Writer.Concrete.EVS
{
    /// <summary>
    /// The orderable item writer.
    /// </summary>
    class OrderableItemWriter : BaseEvsWriter<OrderableItem>
    {
        /// <summary>
        /// Gets the code system.
        /// </summary>
        protected override string CodeSystem
        {
            get { return Constants.OrderableItemCodeSystem; }
        }

        /// <summary>
        /// Gets the name of the code system.
        /// </summary>
        /// <value>
        /// The name of the code system.
        /// </value>
        protected override string CodeSystemName
        {
            get { return Util.Vocabulary.OrderableItem.ToString(); }
        }
    }
}
