﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista orderable item entity.
    /// </summary>
    [Serializable]
    public class OrderableItem : IConcept
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is inactivated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is inactivated; otherwise, <c>false</c>.
        /// </value>
        public bool IsInactivated { get; set; }

        /// <summary>
        /// Gets or sets the name of the package.
        /// </summary>
        /// <value>
        /// The name of the package.
        /// </value>
        public string PackageName { get; set; }

        /// <summary>
        /// Gets or sets the display group id.
        /// </summary>
        /// <value>
        /// The display group id.
        /// </value>
        public int? DisplayGroupId { get; set; }


        public override string ToString()
        {
            return "OrderableItem:" + Name;
        }
    }
}
