﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaWorker.Abstract
{
    /// <summary>
    /// Reader manager interface responsible for reading data and instructing the writer for writing operations.
    /// </summary>
    public interface IReaderManager
    {
        /// <summary>
        /// Starts reading and writing to the writer session.
        /// </summary>
        /// <param name="controller">The controller.</param>
        void Start(Controller controller);

        /// <summary>
        /// Stops the process of reading and writing to the associated writers' sessions.
        /// </summary>
        void Stop();

    }
}
