﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Reader.LogTables;


namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The order action log data.
    /// </summary>
    public class OrderActionLog : BaseLogData<OrderableItemLog, OrderAction>
    {

        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get; set; }


        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }


        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return entity.IEN; } set { entity.IEN = value; } }
        /// <summary>
        /// Gets or sets the date time ordered.
        /// </summary>
        /// <value>
        /// The date time ordered.
        /// </value>
        public DateTime DateTimeOrdered { get { return entity.DateTimeOrdered; } set { entity.DateTimeOrdered = value; } }
        /// <summary>
        /// Gets or sets the order text.
        /// </summary>
        /// <value>
        /// The order text.
        /// </value>
        public string OrderText { get { return entity.OrderText; } set { entity.OrderText = value; } }
        /// <summary>
        /// Gets or sets the signature status.
        /// </summary>
        /// <value>
        /// The signature status.
        /// </value>
        public string SignatureStatus { get { return entity.SignatureStatus; } set { entity.SignatureStatus = value; } }
        /// <summary>
        /// Gets or sets the date time signed.
        /// </summary>
        /// <value>
        /// The date time signed.
        /// </value>
        public DateTime? DateTimeSigned { get { return entity.DateTimeSigned; } set { entity.DateTimeSigned = value; } }
        /// <summary>
        /// Gets or sets the signed by id.
        /// </summary>
        /// <value>
        /// The signed by id.
        /// </value>
        public int? SignedById { get { return entity.SignedById; } set { entity.SignedById = value; } }
        /// <summary>
        /// Gets or sets the new name of the person.
        /// </summary>
        /// <value>
        /// The new name of the person.
        /// </value>
        public string NewPersonName { get { return entity.NewPersonName; } set { entity.NewPersonName = value; } }
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>
        public int ProviderId { get { return entity.ProviderId; } set { entity.ProviderId = value; } }
        /// <summary>
        /// Gets or sets the date time nurse verified.
        /// </summary>
        /// <value>
        /// The date time nurse verified.
        /// </value>
        public DateTime? DateTimeNurseVerified { get { return entity.DateTimeNurseVerified; } set { entity.DateTimeNurseVerified = value; } }
        /// <summary>
        /// Gets or sets the verifying nurse id.
        /// </summary>
        /// <value>
        /// The verifying nurse id.
        /// </value>
        public int? VerifyingNurseId { get { return entity.VerifyingNurseId; } set { entity.VerifyingNurseId = value; } }
        /// <summary>
        /// Gets or sets the date time clerk verified.
        /// </summary>
        /// <value>
        /// The date time clerk verified.
        /// </value>
        public DateTime? DateTimeClerkVerified { get { return entity.DateTimeClerkVerified; } set { entity.DateTimeClerkVerified = value; } }
        /// <summary>
        /// Gets or sets the verifying clerk id.
        /// </summary>
        /// <value>
        /// The verifying clerk id.
        /// </value>
        public int? VerifyingClerkId { get { return entity.VerifyingClerkId; } set { entity.VerifyingClerkId = value; } }
        /// <summary>
        /// Gets or sets the release date time.
        /// </summary>
        /// <value>
        /// The release date time.
        /// </value>
        public DateTime? ReleaseDateTime { get { return entity.ReleaseDateTime; } set { entity.ReleaseDateTime = value; } }
        /// <summary>
        /// Gets or sets the release status.
        /// </summary>
        /// <value>
        /// The release status.
        /// </value>
        public string ReleaseStatus { get { return entity.ReleaseStatus; } set { entity.ReleaseStatus = value; } }

        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public int OrderId { get { return entity.OrderId; } set { entity.OrderId = value; } }

    }
}