﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Reader.Abstract;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The orderable item log data.
    /// </summary>
    public class OrderableItemLog : BaseEisEvsLogData<OrderableItem>
    {


        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get; set; }



        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return Convert.ToInt32(entity.IEN); } set { entity.IEN = value + ""; } }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get { return entity.Name; } set { entity.Name = value; } }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is inactivated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is inactivated; otherwise, <c>false</c>.
        /// </value>
        public bool IsInactivated { get { return entity.IsInactivated; } set { entity.IsInactivated = value; } }
        /// <summary>
        /// Gets or sets the name of the package.
        /// </summary>
        /// <value>
        /// The name of the package.
        /// </value>
        public string PackageName { get { return entity.PackageName; } set { entity.PackageName = value; } }
        /// <summary>
        /// Gets or sets the display group id.
        /// </summary>
        /// <value>
        /// The display group id.
        /// </value>
        public int? DisplayGroupId { get { return entity.DisplayGroupId; } set { entity.DisplayGroupId = value; } }


    }
}
