﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Reader.Abstract;
using BMS.VistaWorker.Abstract;
namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    public class PatientLog : BaseEisEvsLogData<Patient>
    {
        /// <summary>
        /// Gets the crud action.k
        /// </summary>
        public override CrudAction CrudAction { get; set; }

        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }

        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }

        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return Convert.ToInt32(entity.IEN); } set { entity.IEN = value + ""; } }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get { return entity.Name; } set { entity.Name = value; } }

        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        /// <value>
        /// The sex.
        /// </value>
        public char Sex { get { return entity.Sex; } set { entity.Sex = value; } }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public int? WardLocationId { get { return entity.WardLocationId; } set { entity.WardLocationId = value; } }

        /// <summary>
        /// Gets or sets the room bed id.
        /// </summary>
        /// <value>
        /// The room bed id.
        /// </value>
        public int? RoomBedId { get { return entity.RoomBedId; } set { entity.RoomBedId = value; } }

        /// <summary>
        /// Gets or sets the name of the treating specialty.
        /// </summary>
        /// <value>
        /// The name of the treating specialty.
        /// </value>
        public string TreatingSpecialtyName { get { return entity.TreatingSpecialtyName; } set { entity.TreatingSpecialtyName = value; } }

        /// <summary>
        /// Gets or sets the social security number.
        /// </summary>
        /// <value>
        /// The social security number.
        /// </value>
        public string SocialSecurityNumber { get { return entity.SocialSecurityNumber; } set { entity.SocialSecurityNumber = value; } }

        /// <summary>
        /// Gets or sets the current movement id.
        /// </summary>
        /// <value>
        /// The current movement id.
        /// </value>
        public int? CurrentMovementId { get { return entity.CurrentMovementId; } set { entity.CurrentMovementId = value; } }

        /// <summary>
        /// Gets or sets the current admission id.
        /// </summary>
        /// <value>
        /// The current admission id.
        /// </value>
        public int? CurrentAdmissionId { get { return entity.CurrentAdmissionId; } set { entity.CurrentAdmissionId = value; } }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        public DateTime DateOfBirth { get { return entity.DateOfBirth; } set { entity.DateOfBirth = value; } }

        /// <summary>
        /// Gets or sets the name of the marital status.
        /// </summary>
        /// <value>
        /// The name of the marital status.
        /// </value>
        public string MaritalStatusName { get { return entity.MaritalStatusName; } set { entity.MaritalStatusName = value; } }

        /// <summary>
        /// Gets or sets the marital status id.
        /// </summary>
        /// <value>
        /// The marital status id.
        /// </value>
        public int? MaritalStatusId { get { return entity.MaritalStatusId; } set { entity.MaritalStatusId = value; } }

        /// <summary>
        /// Gets or sets the name1 u4 N.
        /// </summary>
        /// <value>
        /// The name1 u4 N.
        /// </value>
        public string Name1U4N { get { return entity.Name1U4N; } set { entity.Name1U4N = value; } }

        /// <summary>
        /// Gets or sets the treating specialty id.
        /// </summary>
        /// <value>
        /// The treating specialty id.
        /// </value>
        public int? TreatingSpecialtyId { get { return entity.TreatingSpecialtyId; } set { entity.TreatingSpecialtyId = value; } }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>
        public string AdmittingDiagnosis { get { return entity.AdmittingDiagnosis; } set { entity.AdmittingDiagnosis = value; } }

        /// <summary>
        /// Gets or sets the service connected percentage.
        /// </summary>
        /// <value>
        /// The service connected percentage.
        /// </value>
        public int? ServiceConnectedPercentage { get { return entity.ServiceConnectedPercentage; } set { entity.ServiceConnectedPercentage = value; } }

        /// <summary>
        /// Gets or sets the attending physician id.
        /// </summary>
        /// <value>
        /// The attending physician id.
        /// </value>
        public int? AttendingPhysicianId { get { return entity.AttendingPhysicianId; } set { entity.AttendingPhysicianId = value; } }

        /// <summary>
        /// Gets or sets the attending physician.
        /// </summary>
        /// <value>
        /// The attending physician.
        /// </value>
        public NewPerson AttendingPhysician { get { return entity.AttendingPhysician; } set 
        { 
            entity.AttendingPhysician = value; 
        } 
        }

    }
}
