﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;
using BMS.VistaIntegration.Mdws2.Maps.Entities;
using BMS.VistaIntegration.Mdws2.Entities;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class PatientAppointmentPatientMap : FileMap<PatientAppointment>
    {
        private static readonly PatientAppointmentPatientMap instance = new PatientAppointmentPatientMap();
        public static PatientAppointmentPatientMap Instance { get { return instance; } }

        private PatientAppointmentPatientMap()
        {
        }

        protected override void Map()
        {
            MapIen((m, s) => { });
            Map((m, s) => m.HospitalLocationId = s, ".01");
            Map((m, s) => m.AppointmentDateTime = s.VistAToDateTime(), ".001", true);
            Map((m, s) => m.TelephoneOfClinic = s, ".02", true);
            Map((m, s) => m.Status = s, "3", true);
            Map((m, s) => m.DataEntryClerkId = s, "19", true);
            Map((m, s) => m.DateAppointmentMade = s.VistAToDateTime(), "20", true);
            Map((m, s) => m.CurrentStatus = s, "100", true);
        }

        public override string FileNumber
        {
            get { return "2.98"; }
        }
    }
}
