﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;
using BMS.VistaIntegration.Mdws2.Maps.EVS;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class OrderMap : FileMap<Order>
    {
        private static OrderMap instance = new OrderMap();
        public static OrderMap Instance { get { return instance; } }

        private OrderMap()
        {
        }

        public override string FileNumber
        {
            get { return "100"; }
        }

        public override Order Make()
        {

            Order order = base.Make();
            order.OrderOrderableItemIds = new List<string>();
            return order;

        }

        protected override void Map()
        {

            MapIen((m, s) => m.IEN = s);
            Map((m, s) => m.OrderNumber = s, ".01");
            Map(MapObjectOfOrder, ".02");
            Map((m, s) => m.LastActivityDate = s.VistAToDateTime(), "31");
            Map((m, s) => m.StatusId = s, "5");
            Map(MapHospitalLocation, "6");
            Map((m, s) => m.StartDate = s.VistAToDateTime(), "21");
            Map((m, s) => m.StopDate = s.VistAToDateTime(), "22");
            Map((m, s) => m.DC_Date = s.VistAToDateTime(), "63");
            Map((m, s) => m.DisplayGroupId = s, "23");
            MapMultiple(".1", "100.001");
            Map((m, s) => m.OrderOrderableItemIds.Add(s), "100.001", ".01");
            MapTypeReference((m, s) => m.Patient = s, PatientMap.Instance, ".02", "DPT(");
            MapReference((m, s) => m.OrderStatus = s, OrderStatusMap.Instance, "5");

        }

        private static void MapObjectOfOrder(Order order, string s)
        {

            string type = s.VistAVariablePointerType();
            if (type == "DPT(")
                order.PatientId = s.VistAVariablePointerValue();
            else if (type == "LRT(67,")
                order.ReferralPatientId = s.VistAVariablePointerValue();

        }

        private static void MapHospitalLocation(Order order, string s)
        {

            string type = s.VistAVariablePointerType();
            if (type == "SC(")
                order.HospitalLocationId = s.VistAVariablePointerValue();

        }


    }
}
