﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class OrderActionMap : SubFileMap<Order, OrderAction>
    {
        private static readonly OrderActionMap instance = new OrderActionMap();
        public static OrderActionMap Instance { get { return instance; } }
        private OrderActionMap()
            : base(OrderMap.Instance)
        {
        }

        public override string SubFileNumber
        {
            get { return "100.008"; }
        }

        public override string FieldIenForSubFile
        {
            get { return ".8"; }
        }

        public override string FirstFieldIenForSubFile
        {
            get { return ".01"; }
        }

        public override OrderAction MakeSubFile(Order file)
        {

                return new OrderAction()
                {
                    OrderId = file.IEN,
                    Order = file,
                };

        }

        protected override void Map()
        {
            
  
                Map((m, s) => m.DateTimeOrdered = s.VistAToDateTime(), ".01");
                Map((m, s) => m.OrderText = s, ".1");
                Map((m, s) => m.SignatureStatus = s, "4");
                Map((m, s) => m.DateTimeSigned = s.VistAToDateTime(), "6");
                Map((m, s) => m.SignedById = s, "5");
                Map((m, s) => m.ProviderId = s, "3");
                Map((m, s) => m.DateTimeNurseVerified = s.VistAToDateTime(), "9");
                Map((m, s) => m.VerifyingNurseId = s, "8");
                Map((m, s) => m.DateTimeClerkVerified = s.VistAToDateTime(), "11");
                Map((m, s) => m.VerifyingClerkId = s, "10");
                Map((m, s) => m.ReleaseDateTime = s.VistAToDateTime(), "16");
                Map((m, s) => m.ReleaseStatus = s, "15");

                MapReference((m, s) => m.SignedBy = s, NewPersonMap.Instance, "5");
                MapReference((m, s) => m.Provider = s, NewPersonMap.Instance, "3");
                MapReference((m, s) => m.VerifyingNurse = s, NewPersonMap.Instance, "8");
                MapReference((m, s) => m.VerifyingClerk = s, NewPersonMap.Instance, "10");
  
        }


    }
}
