﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Mdws2.Maps;

namespace BMS.VistaIntegration.Mdws2.Implementation
{
    public abstract class BaseCommand<T>
        where T : class , new()
    {
        private readonly IFileMap<T> fileMap;

        protected BaseCommand(IFileMap<T> fileMap)
        {
                HasMore = true;
                this.fileMap = fileMap;
        }

        public DateTime? StartDate { get; set; }
        public DateTime? EndDate { get; set; }

        protected virtual String GetIndexParam() { return null; }
        protected virtual String GetScreenParam() { return null; }
        protected virtual Predicate<T> GetPredicate() { return null; }
        protected virtual string Ien { get { return null; } }

        public int? MaxCount { get; set; }
        public string FromIenParam { get; set; }
        public string LastIen { get; private set; }
        public bool HasMore { get; private set; }

       

        public virtual IList<T> Execute(QuerySvcSoap client)
        {
                var query = fileMap.MakeQuery();
                query.Iens = Ien;
                query.Client = client;
                query.BulkCount = MaxCount;
                query.FromParam = FromIenParam;
                query.IndexParam = GetIndexParam();
                query.ScreenParam = GetScreenParam();
                query.FilterPredicate = GetPredicate();
                var result = query.GetResult();
                LastIen = query.LastIen;
                HasMore = query.HasMore;
                return result;
        }
    }
}
