﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA scheduled admission contract.
    /// </summary>
    [Serializable]
    public class ScheduledAdmission: IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>

        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>

        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the reservation date time.
        /// </summary>
        /// <value>
        /// The reservation date time.
        /// </value>

        public DateTime ReservationDateTime { get; set; }

        /// <summary>
        /// Gets or sets the length of stay expected.
        /// </summary>
        /// <value>
        /// The length of stay expected.
        /// </value>

        public int? LengthOfStayExpected { get; set; }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>

        public string AdmittingDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>

        public string ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the scheduler id.
        /// </summary>
        /// <value>
        /// The scheduler id.
        /// </value>

        public string SchedulerId { get; set; }

        /// <summary>
        /// Gets or sets the surgery.
        /// </summary>
        /// <value>
        /// The surgery.
        /// </value>

        public string Surgery { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>

        public string WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the treating specialty id.
        /// </summary>
        /// <value>
        /// The treating specialty id.
        /// </value>

        public string TreatingSpecialtyId { get; set; }

        /// <summary>
        /// Gets or sets the medical center division id.
        /// </summary>
        /// <value>
        /// The medical center division id.
        /// </value>

        public string MedicalCenterDivisionId { get; set; }

        /// <summary>
        /// Gets or sets the date time cancelled.
        /// </summary>
        /// <value>
        /// The date time cancelled.
        /// </value>

        public DateTime? DateTimeCancelled { get; set; }

        /// <summary>
        /// Gets or sets the cancelled by id.
        /// </summary>
        /// <value>
        /// The cancelled by id.
        /// </value>

        public string CancelledById { get; set; }

        public NewPerson Scheduler { get; set; }

        public Patient Patient { get; set; }

        public NewPerson Provider { get; set; }

        public MedicalCenterDivision MedicalCenterDivision { get; set; }

        public FacilityTreatingSpecialty TreatingSpecialty { get; set; }

        public WardLocation Ward { get; set; }

        public override string ToString()
        {
            string patient = Patient != null ? Patient.Name : "NULL";
            return string.Format("ScheduledAdmission {0} for patient {1}", IEN, patient);
        }

    }
}
