﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA patient movement contract.
    /// </summary>
    [Serializable]
    public class PatientMovement : IEntity
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>

        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the date time.
        /// </summary>
        /// <value>
        /// The date time.
        /// </value>

        public DateTime DateTime { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>

        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the transaction type id.
        /// </summary>
        /// <value>
        /// The transaction type id.
        /// </value>

        public string TransactionTypeId { get; set; }

        /// <summary>
        /// Gets or sets the type of movement id.
        /// </summary>
        /// <value>
        /// The type of movement id.
        /// </value>

        public string TypeOfMovementId { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>

        public string WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the room bed id.
        /// </summary>
        /// <value>
        /// The room bed id.
        /// </value>

        public string RoomBedId { get; set; }

        /// <summary>
        /// Gets or sets the entered by id.
        /// </summary>
        /// <value>
        /// The entered by id.
        /// </value>

        public string EnteredById { get; set; }

        /// <summary>
        /// Gets or sets the entered on date.
        /// </summary>
        /// <value>
        /// The entered on date.
        /// </value>

        public DateTime? EnteredOnDateTime { get; set; }

        public Patient Patient { get; set; }

        public NewPerson EnteredBy { get; set; }

        public FacilityMovementType TypeOfMovement { get; set; }

        public RoomBed Bed { get; set; }

        public WardLocation Ward { get; set; }

        public string CurrentAdmissionIen { get; set; }

        public override string ToString()
        {
            string patient = Patient != null ? Patient.Name : "NULL";
            return string.Format("PatientMovement {0} for patient {1}", IEN, patient);
        }
    }
}
