﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Data;
using InterSystems.Data.CacheClient;
using BMS.VistaIntegration.Exceptions;
using System.Data;

namespace BMS.VistaIntegration.Cache
{
    public class CacheVistASession : IVistASession
    {
        public VistASite VistASite { get; private set; }
        private bool _isOpen = false;
        private bool _isDisposed = false;
        public CacheConnection OdbcConnection { get; private set; }
        public string Schema { get; private set; }

        public CacheVistASession(VistASite site)
        {
            VistASite = site;
        }

        public void Open(VistAConnectionInfo vistASite)
        {
            if (_isOpen) throw new InvalidOperationException("CACHE ODBC: VistA session is already open!");
            if (_isDisposed) throw new ObjectDisposedException("CACHEVistASession");
            if (string.IsNullOrEmpty(vistASite.ConnectionString))
                throw new VistAConnectionException("CACHE ODBC connection string is null or empty!");
            if (string.IsNullOrEmpty(vistASite.AccessCode))
                throw new VistAConnectionException("CACHE ODBC user name is null or empty!");
            if (string.IsNullOrEmpty(vistASite.VerifyCode))
                throw new VistAConnectionException("CACHE ODBC password is null or empty!");

            string schema = null;
            this.OdbcConnection = Utils.ParseConnectionString(vistASite.ConnectionString, vistASite.AccessCode, vistASite.VerifyCode, out schema);
            this.Schema = schema;
            if (OdbcConnection != null)
            {
                try
                {
                    OdbcConnection.Open();
                    _isOpen = true;
                }
                catch (Exception ex)
                {
                    throw new VistAConnectionException(ex);
                }
            }
        }

        public void Close()
        {
            if (_isDisposed) return;
            _isDisposed = true;
            _isOpen = false;
            if (OdbcConnection == null) return;
            OdbcConnection.Close();
        }

        public IVistAQuery MakeQuery()
        {
            return new CacheVistAQuery(this);
        }

        public void Dispose()
        {
            Close();
        }

        public bool IsAlive()
        {
            return true;
        }

        public void Test(VistAConnectionInfo connection)
        {
            this.Open(connection);
        }
    }
}
