﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// General transfer data class. Contains data about transfers used to manipulate transfers in BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Transfer")]
    [DataContract(Name = "Transfer")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class Transfer : Act
    {
        /// <summary>
        /// Gets or sets the facility from where the patient is transfered(EIS place).
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 1)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the community hospital from the facility from where the patient is transfered(EIS place).
        /// </summary>
        /// <value>
        /// The community hospital.
        /// </value>
        [XmlElementAttribute("CurrentLocation", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "CurrentLocation", Order = 2)]
        public string CurrentLocation { get; set; }

        /// <summary>
        /// Gets or sets the facility where the patient is transferred.
        /// </summary>
        /// <value>
        /// The admission facility.
        /// </value>
        [XmlElementAttribute("AdmissionFacilityId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionFacilityId", Order = 3)]
        public II AdmissionFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the transfer contract.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        [XmlElementAttribute("Contract", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "Contract", Order = 5)]
        public CD Contract { get; set; }

        /// <summary>
        /// Gets or sets the patient diagnosis.
        /// </summary>
        /// <value>
        /// The diagnosis.
        /// </value>
        [XmlElementAttribute("Diagnosis", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "Diagnosis", Order = 6)]
        public string Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the transfer comments.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [XmlElementAttribute("Comment", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 7)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the authority that enforces the transfer(EVS concept).
        /// </summary>
        /// <value>
        /// The disposition.
        /// </value>
        [XmlElementAttribute("Disposition", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "Disposition", Order = 8)]
        public CD Disposition { get; set; }

        /// <summary>
        /// Gets or sets the disposition date.
        /// </summary>
        /// <value>
        /// The disposition date.
        /// </value>
        [XmlElementAttribute("DispositionDate", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "DispositionDate", Order = 9)]
        public DateTime? DispositionDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge comment.
        /// </summary>
        /// <value>
        /// The discharge comment.
        /// </value>
        [XmlElementAttribute("DischargeComment", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "DischargeComment", Order = 10)]
        public string DischargeComment { get; set; }

        /// <summary>
        /// Gets or sets the era.
        /// </summary>
        /// <value>
        /// The era.
        /// </value>
        [XmlElementAttribute("Era", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "Era", Order = 11)]
        public CD Era { get; set; }

        /// <summary>
        /// Gets or sets the vista speciality.
        /// </summary>
        /// <value>
        /// The vista speciality.
        /// </value>
        [XmlElementAttribute("Speciality", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "Speciality", Order = 12)]
        public CD Speciality { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        [XmlElementAttribute("AdmissionDate", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionDate", Order = 13)]
        public DateTime? AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the type of the operation(used for insert; can be INT, REQ, EVN).
        /// </summary>
        /// <value>
        /// The type of the operation.
        /// </value>
        [XmlElementAttribute("OperationType", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "OperationType", Order = 14)]
        public string OperationType { get; set; }

        /// <summary>
        /// Gets or sets the faciliy's region.
        /// </summary>
        /// <value>
        /// The facility's region.
        /// </value>
        [XmlElementAttribute("FacilityRegion", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityRegion", Order = 15)]
        public string FacilityRegion { get; set; }

        /// <summary>
        /// Gets or sets the faciliy's VISN.
        /// </summary>
        /// <value>
        /// The facility's VISN.
        /// </value>
        [XmlElementAttribute("FacilityVISN", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityVISN", Order = 16)]
        public string FacilityVISN { get; set; }

        /// <summary>
        /// Gets or sets the person that created the transfer.
        /// </summary>
        /// <value>
        /// The person that created the transfer.
        /// </value>
        [XmlElementAttribute("EnteredBy", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredBy", Order = 17)]
        public string EnteredBy { get; set; }

        /// <summary>
        /// Gets or sets the person that last edited the transfer.
        /// </summary>
        /// <value>
        /// The person that last edited the transfer.
        /// </value>
        [XmlElementAttribute("LastEditBy", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditBy", Order = 18)]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the transfer was last edited.
        /// </summary>
        /// <value>
        /// The date and time when the transfer was last edited.
        /// </value>
        [XmlElementAttribute("Edited", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "Edited", Order = 19)]
        public DateTime? Edited { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [XmlElementAttribute("RequestedDate", Order = 20)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedDate", Order = 20)]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 21)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 21)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsNationalWaitList", Order = 22)]
        [DataMember(EmitDefaultValue = false, Name = "IsNationalWaitList", Order = 22)]
        public bool IsNationalWaitList { get; set; }

        /// <summary>
        /// Gets or sets the type of bed or ward needed by the patient(EVS patient).
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [XmlElementAttribute("TypeOfBedWard", Order = 23)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfBedWard", Order = 23)]
        public string TypeOfBedWard { get; set; }

        [XmlElementAttribute("IsFee", Order = 24)]
        [DataMember(EmitDefaultValue = false, Name = "IsFee", Order = 24)]
        public bool IsFee { get; set; }

        [XmlElementAttribute("TransferCoordinator", Order = 25)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinator", Order = 25)]
        public string TransferCoordinator { get; set; }

        [XmlElementAttribute("TransferCoordinatorPhone", Order = 26)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinatorPhone", Order = 26)]
        public string TransferCoordinatorPhone { get; set; }
    }
}
