﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Class for count patients waiting for a bed and scheduled admissions.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "PatientWaitingCount")]
    [DataContract(Name = "PatientWaitingCount")]
    public class PatientWaitingCount
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the waiting list count.
        /// </summary>
        /// <value>
        /// The waiting list count.
        /// </value>
        [XmlElementAttribute("WaitingListCount", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingListCount", Order = 1)]
        public int WaitingListCount { get; set; }

        /// <summary>
        /// Gets or sets the scheduled admissions count.
        /// </summary>
        /// <value>
        /// The scheduled admissions count.
        /// </value>
        [XmlElementAttribute("ScheduledAdmissionsCount", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "ScheduledAdmissionsCount", Order = 2)]
        public int ScheduledAdmissionsCount { get; set; }

        #endregion
    }
}
