﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about vista transfer acts managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "MovementEvent")]
    [DataContract(Name = "MovementEvent")]
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    [KnownType(typeof(Event))]
    public class MovementEvent : Event
    {        
        /// <summary>
        /// Gets or sets the bed from where the patient is moved(EIS place reference).
        /// </summary>
        /// <value>
        /// The old bed id.
        /// </value>
        [XmlElementAttribute("OldBedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "OldBedId", Order = 1)]
        public II OldBedId { get; set; }

        /// <summary>
        /// Gets or sets the ward from where the patient is moved(EIS place reference).
        /// </summary>
        /// <value>
        /// The old ward id.
        /// </value>
        [XmlElementAttribute("OldWardId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "OldWardId", Order = 2)]
        public II OldWardId { get; set; }

        /// <summary>
        /// Gets or sets the type of the movement(VistA related).
        /// </summary>
        /// <value>
        /// The type of the movement.
        /// </value>
        [XmlElementAttribute("MovementType", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "MovementType", Order = 3)]
        public CD MovementType { get; set; }

        /// <summary>
        /// Gets or sets the date when the movement was made.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("MovementDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "MovementDate", Order = 4)]
        public DateTime? MovementDate { get; set; }

        /// <summary>
        /// Gets or sets the person who made the movement.
        /// </summary>
        /// <value>
        /// The entered by id.
        /// </value>
        [XmlElementAttribute("EnteredById", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredById", Order = 5)]
        public II EnteredById { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        /// <value>
        /// The admission id.
        /// </value>
        [XmlElementAttribute("AdmissionId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionId", Order = 6)]
        public II AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the admission ien.
        /// </summary>
        /// <value>
        /// The admission ien.
        /// </value>
        [XmlElementAttribute("AdmissionIen", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionIen", Order = 7)]
        public string AdmissionIen { get; set; }
    }
}
