﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains the data about the discharge appointment clinics.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "HospitalLocationAppointment")]
    [DataContract(Name = "HospitalLocationAppointment")]
    [KnownType(typeof(II))] 
    public class HospitalLocationAppointment
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the hospital location.
        /// </summary>
        /// <value>
        /// The hospital location.
        /// </value>
        [XmlElementAttribute("HospitalLocationId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "HospitalLocationId", Order = 2)]
        public II HospitalLocationId { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 3)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 4)]
        public II VistaSiteId { get; set; }
    }
}
