﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Cotract used for getting the history changes for Bed Staff.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedStaffHistory")]
    [DataContract(Name = "BedStaffHistory")]
    [KnownType(typeof(II))]
    public class BedStaffHistory
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [XmlElementAttribute("BedId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 2)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        [XmlElementAttribute("DivisionId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "DivisionId", Order = 3)]
        public II DivisionId { get; set; }

        /// <summary>
        /// Gets or sets the staff.
        /// </summary>
        /// <value>
        /// The staff.
        /// </value>
        [XmlElementAttribute("Staff", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "Staff", Order = 4)]
        public string Staff { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 5)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 6)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the transaction type code.
        /// </summary>
        /// <value>
        /// The transaction type code.
        /// </value>
        [XmlElementAttribute("TransactionTypeCode", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "TransactionTypeCode", Order = 7)]
        public string TransactionTypeCode { get; set; }

        /// <summary>
        /// Gets or sets the creation date.
        /// </summary>
        /// <value>
        /// The creation date.
        /// </value>
        [XmlElementAttribute("CreationDate", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "CreationDate", Order = 8)]
        public DateTime? CreationDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [XmlElementAttribute("CreatedBy", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "CreatedBy", Order = 9)]
        public string CreatedBy { get; set; }
    }
}
