﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about staff assigned to bed.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedStaff")]
    [DataContract(Name = "BedStaff")]    
    [KnownType(typeof(II))]    
    public class BedStaff
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        [XmlElementAttribute("BedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 1)]
        public II BedId { get; set; }
        
        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        [XmlElementAttribute("DivisionId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "DivisionId", Order = 1)]
        public II DivisionId { get; set; }

        /// <summary>
        /// Gets or sets the staff.
        /// </summary>
        /// <value>
        /// The staff.
        /// </value>
        [XmlElementAttribute("Staff", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Staff", Order = 3)]
        public string Staff { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 4)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 5)]
        public II FacilityId { get; set; }
    }
}
