﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using BMS.DataContracts;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains the number of occupied beds and unavailable beds.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedOccupancyCount")]
    [DataContract(Name = "BedOccupancyCount")]
    [KnownType(typeof(II))]
    public class BedOccupancyCount
    {

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        [XmlElementAttribute("BedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 1)]
        public II BedId { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether this instance is occupied bed.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is occupied bed; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsOccupiedBed", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "IsOccupiedBed", Order = 2)]
        public bool IsOccupiedBed { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether this instance is unavailable bed.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is unavailable bed; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsUnavailableBed", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "IsUnavailableBed", Order = 3)]
        public bool IsUnavailableBed { get; set; }
    }

}
