﻿using System;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorHospitalLocationAppointment
    {
        public static void CopyTo(this HospitalLocationAppointmentBO hospitalLocationAppointmentBO, DataContracts.HospitalLocationAppointment hospitalLocationAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                hospitalLocationAppointment.Id = TranslatorUtils.BuildIdentifier(hospitalLocationAppointmentBO.DOMAIN_ID, hospitalLocationAppointmentBO.ID);
                hospitalLocationAppointment.HospitalLocationId = TranslatorUtils.BuildIdentifier(hospitalLocationAppointmentBO.DOMAIN_ID, hospitalLocationAppointmentBO.HOSPITAL_LOCATION_UID);
                hospitalLocationAppointment.FacilityId = TranslatorUtils.BuildIdentifier(hospitalLocationAppointmentBO.DOMAIN_ID, hospitalLocationAppointmentBO.FACILITY_UID);
                hospitalLocationAppointment.VistaSiteId = TranslatorUtils.BuildIdentifier(hospitalLocationAppointmentBO.DOMAIN_ID, hospitalLocationAppointmentBO.VISTA_SITE_UID);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.HospitalLocationAppointment hospitalLocationAppointment, HospitalLocationAppointmentBO hospitalLocationAppointmentBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (hospitalLocationAppointment.Id != null)
                {
                    hospitalLocationAppointmentBO.DOMAIN_ID.Value = hospitalLocationAppointment.Id.root;
                    if (string.IsNullOrEmpty(hospitalLocationAppointment.Id.extension))
                    {
                        int id;
                        if (int.TryParse(hospitalLocationAppointment.Id.extension, out id))
                            hospitalLocationAppointmentBO.ID.Value = id;
                    }
                }
                if (hospitalLocationAppointment.HospitalLocationId != null)
                    hospitalLocationAppointmentBO.HOSPITAL_LOCATION_UID.Value = Guid.Parse(hospitalLocationAppointment.HospitalLocationId.extension);               
                if (hospitalLocationAppointment.FacilityId != null)
                    hospitalLocationAppointmentBO.FACILITY_UID.Value = Guid.Parse(hospitalLocationAppointment.FacilityId.extension);                
                if (hospitalLocationAppointment.VistaSiteId != null)
                    hospitalLocationAppointmentBO.VISTA_SITE_UID.Value = Guid.Parse(hospitalLocationAppointment.VistaSiteId.extension);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
