﻿using System;
using System.Linq;
using System.ServiceModel;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;

namespace BMS.Translators
{
    public static class TranslatorDischargeAppointment
    {
        public static void CopyTo(this DischargeIntBO dischargeAppointmentBO, DataContracts.DischargeAppointment dischargeAppointment)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                dischargeAppointment.AppointmentDate = dischargeAppointmentBO.APPOINTMENT_DATE.Value;
                dischargeAppointment.EnteredDate = dischargeAppointmentBO.DATE_ENTERED.Value;                
                dischargeAppointment.HospitalLocationId = TranslatorUtils.BuildIdentifier(dischargeAppointmentBO.DOMAIN_ID, dischargeAppointmentBO.HOSPITAL_LOCATION_UID);
                dischargeAppointment.Id = TranslatorUtils.BuildIdentifier(dischargeAppointmentBO.DOMAIN_ID, dischargeAppointmentBO.ID);                
                dischargeAppointment.IsActive = dischargeAppointmentBO.IS_ACTIVE.Value;                
                dischargeAppointment.PatientId = TranslatorUtils.BuildIdentifier(dischargeAppointmentBO.DOMAIN_ID, dischargeAppointmentBO.PATIENT_UID);                
                dischargeAppointment.Status = dischargeAppointmentBO.STATUS.Value;
                dischargeAppointment.VistaSiteId = TranslatorUtils.BuildIdentifier(dischargeAppointmentBO.DOMAIN_ID, dischargeAppointmentBO.VISTA_SITE_UID);
                dischargeAppointment.WardId = TranslatorUtils.BuildIdentifier(dischargeAppointmentBO.DOMAIN_ID, dischargeAppointmentBO.WARD_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.DischargeAppointment dischargeAppointment, DischargeIntBO dischargeAppointmentBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                dischargeAppointmentBO.APPOINTMENT_DATE.Value = dischargeAppointment.AppointmentDate;
                dischargeAppointmentBO.DATE_ENTERED.Value = dischargeAppointment.EnteredDate;
                if (dischargeAppointment.HospitalLocationId != null)
                    dischargeAppointmentBO.HOSPITAL_LOCATION_UID.Value = Guid.Parse(dischargeAppointment.HospitalLocationId.extension);
                if (dischargeAppointment.Id != null)
                {
                    dischargeAppointmentBO.DOMAIN_ID.Value = dischargeAppointment.Id.root;
                    int? actId = dischargeAppointment.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        dischargeAppointmentBO.ID.Value = actId.Value;
                }                
                dischargeAppointmentBO.IS_ACTIVE.Value = dischargeAppointment.IsActive;                
                if (dischargeAppointment.PatientId != null)
                    dischargeAppointmentBO.PATIENT_UID.Value = Guid.Parse(dischargeAppointment.PatientId.extension);                
                dischargeAppointmentBO.STATUS.Value = dischargeAppointment.Status;
                if (dischargeAppointment.VistaSiteId != null)
                    dischargeAppointmentBO.VISTA_SITE_UID.Value = Guid.Parse(dischargeAppointment.VistaSiteId.extension);
                if (dischargeAppointment.WardId != null)
                    dischargeAppointmentBO.WARD_UID.Value = Guid.Parse(dischargeAppointment.WardId.extension);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
