﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;
using DC = BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorCancelableOrderInfo
    {
        public static void CopyTo(this CancelableOrderInfoBO cancelableOrderInfoBO, out DataContracts.Order order)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (cancelableOrderInfoBO.ACT_TYPE == null)
                    order = null;
                switch (cancelableOrderInfoBO.ACT_TYPE.Value)
                {
                    case (int)MovementTransactionType.ADMISSION:
                        order = new DC.AdmissionOrder();
                        break;
                    case (int)MovementTransactionType.TRANSFER:
                        order = new DC.MovementOrder();
                        break;
                    case (int)MovementTransactionType.DISCHARGE:
                        order = new DC.DischargeOrder();
                        break;
                    default:
                        order = null;
                        break;
                }
                if (order == null)
                    return;

                order.Id = TranslatorUtils.BuildIdentifier(cancelableOrderInfoBO.DOMAIN_ID, cancelableOrderInfoBO.ID);
                order.Ien = cancelableOrderInfoBO.IEN.Value;
                order.OrderedDate = (cancelableOrderInfoBO.ORDERED_DATE.Value.HasValue) ? cancelableOrderInfoBO.ORDERED_DATE.Value.Value : DateTime.UtcNow;
                //order.PatientId = TranslatorUtils.BuildIdentifier(cancelableOrderInfoBO.DOMAIN_ID, cancelableOrderInfoBO.PATIENT_UID);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
