﻿using BMS.MT;
using System;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Translators
{
    public static class TranslatorBedUnavailable
    {
        public static void CopyTo(this DataContracts.BedUnavailable bedUnavailable, BedUnavailableBO bedUnavailableBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedUnavailableBO.CANCELED_DATE.Value = bedUnavailable.CanceledDate;
                bedUnavailableBO.CREATION_DATE.Value = bedUnavailable.CreationDate;
                if (bedUnavailable.Id != null)
                {
                    bedUnavailableBO.DOMAIN_ID.Value = bedUnavailable.Id.root;
                    int? actId = bedUnavailable.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        bedUnavailableBO.ACT_ID.Value = actId.Value;
                }
                if (bedUnavailable.Parent != null && bedUnavailable.Parent.Id != null)
                    bedUnavailableBO.PARENT_ACT_ID.Value = bedUnavailable.Parent.Id.extension.ParseAsInt();
                if (bedUnavailable.FlowId != null)
                    bedUnavailableBO.FLOW_ID.Value = bedUnavailable.FlowId;
                bedUnavailableBO.IEN.Value = bedUnavailable.IEN;
                if (bedUnavailable.Type != null)
                {
                    bedUnavailableBO.TYPE_CODE.Value = bedUnavailable.Type.code;
                    bedUnavailableBO.TYPE_CODE_SYSTEM.Value = bedUnavailable.Type.codeSystem;
                    bedUnavailableBO.TYPE_CODE_SYSTEM_NAME.Value = bedUnavailable.Type.codeSystemName;
                    bedUnavailableBO.TYPE_DISPLAY_NAME.Value = bedUnavailable.Type.displayName;
                }
                if (bedUnavailable.Reason != null)
                {
                    bedUnavailableBO.REASON_CODE.Value = bedUnavailable.Reason.code;
                    bedUnavailableBO.REASON_CODE_SYSTEM.Value = bedUnavailable.Reason.codeSystem;
                    bedUnavailableBO.REASON_CODE_SYSTEM_NAME.Value = bedUnavailable.Reason.codeSystemName;
                    bedUnavailableBO.REASON_DISPLAY_NAME.Value = bedUnavailable.Reason.displayName;
                }
                if (bedUnavailable.DivisionId != null)
                    bedUnavailableBO.DIVISION_UID.Value = System.Guid.Parse(bedUnavailable.DivisionId.extension);                    
                if (bedUnavailable.BedId != null)
                    bedUnavailableBO.BED_UID.Value = System.Guid.Parse(bedUnavailable.BedId.extension);                    
                bedUnavailableBO.CREATED_BY.Value = bedUnavailable.CreatedBy;
                bedUnavailableBO.EDITED_BY.Value = bedUnavailable.EditedBy;
                bedUnavailableBO.EDITED_DATE.Value = bedUnavailable.EditedDate;
                bedUnavailableBO.COMPLETED_BY.Value = bedUnavailable.CanceledBy;
                bedUnavailableBO.COMPLETED_DATE.Value = bedUnavailable.CanceledDate;
                if (bedUnavailable.VistaSiteId != null)
                    bedUnavailableBO.VISTA_SITE_UID.Value = System.Guid.Parse(bedUnavailable.VistaSiteId.extension);                
                bedUnavailableBO.IS_UNAVAILABLE_FROM_VISTA.Value = bedUnavailable.IsUnavailableFromVistA;
                bedUnavailableBO.WARD_LIST.Value = string.Empty;
                if (bedUnavailable.WardList != null && bedUnavailable.WardList.Count > 0)
                {
                    foreach (II id in bedUnavailable.WardList)
                        bedUnavailableBO.WARD_LIST.Value += id.extension + ",";
                }
                bedUnavailableBO.EXPECTED_COMPLETED_DATE.Value = bedUnavailable.ExpectedCompletedDate;

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this BedUnavailableBO bedUnavailableBO, DataContracts.BedUnavailable bedUnavailable)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedUnavailable.CanceledDate = bedUnavailableBO.CANCELED_DATE.Value;
                bedUnavailable.CreationDate = bedUnavailableBO.CREATION_DATE.Value;
                bedUnavailable.Id = TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID, bedUnavailableBO.ACT_ID);
                if (bedUnavailableBO.PARENT_ACT_ID.Value.HasValue)
                {
                    bedUnavailable.Parent = new DataContracts.Act();
                    bedUnavailable.Parent.Id = TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID, bedUnavailableBO.PARENT_ACT_ID);
                }
                bedUnavailable.FlowId = bedUnavailableBO.FLOW_ID.Value;
                bedUnavailable.IEN = bedUnavailableBO.IEN.Value;
                bedUnavailable.Type = TranslatorUtils.BuildConcept(bedUnavailableBO.TYPE_CODE, bedUnavailableBO.TYPE_CODE_SYSTEM, bedUnavailableBO.TYPE_CODE_SYSTEM_NAME, bedUnavailableBO.TYPE_DISPLAY_NAME);
                bedUnavailable.Reason = TranslatorUtils.BuildConcept(bedUnavailableBO.REASON_CODE, bedUnavailableBO.REASON_CODE_SYSTEM, bedUnavailableBO.REASON_CODE_SYSTEM_NAME, bedUnavailableBO.REASON_DISPLAY_NAME);
                bedUnavailable.DivisionId = TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID, bedUnavailableBO.DIVISION_UID);
                bedUnavailable.BedId = TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID, bedUnavailableBO.BED_UID);
                bedUnavailable.CreatedBy = bedUnavailableBO.CREATED_BY.Value;
                bedUnavailable.EditedBy = bedUnavailableBO.EDITED_BY.Value;
                bedUnavailable.EditedDate = bedUnavailableBO.EDITED_DATE.Value;
                bedUnavailable.CanceledBy = bedUnavailableBO.COMPLETED_BY.Value;
                bedUnavailable.VistaSiteId = TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID, bedUnavailableBO.VISTA_SITE_UID);
                bedUnavailable.IsUnavailableFromVistA = bedUnavailableBO.IS_UNAVAILABLE_FROM_VISTA.Value;
                if (bedUnavailableBO.WARD_LIST.Value.EndsWith(","))
                    bedUnavailableBO.WARD_LIST.Value = bedUnavailableBO.WARD_LIST.Value.Substring(0, bedUnavailableBO.WARD_LIST.Value.Length - 1);
                string[] wardList = bedUnavailableBO.WARD_LIST.Value.Split(',');
                bedUnavailable.WardList = new List<II>();
                for (int i = 0; i < wardList.Length; i++)
                    bedUnavailable.WardList.Add(TranslatorUtils.BuildIdentifier(bedUnavailableBO.DOMAIN_ID.Value, wardList[i]));
                bedUnavailable.ExpectedCompletedDate = bedUnavailableBO.EXPECTED_COMPLETED_DATE.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
