﻿using BMS.MT;
using System;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorBedStaff
    {
        public static void CopyTo(this BedStaffBO bedStaffBO, DataContracts.BedStaff bedStaff, string domainId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedStaff.BedId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffBO.BED_UID.Value.HasValue) ? bedStaffBO.BED_UID.Value.Value.ToString() : null);
                bedStaff.DivisionId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffBO.DIVISION_UID.Value.HasValue) ? bedStaffBO.DIVISION_UID.Value.Value.ToString() : null);
                bedStaff.Staff = bedStaffBO.STAFF.Value;
                bedStaff.PatientId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffBO.PATIENT_UID.Value.HasValue) ? bedStaffBO.PATIENT_UID.Value.Value.ToString() : null);
                bedStaff.FacilityId = TranslatorUtils.BuildIdentifier(domainId, (bedStaffBO.FACILITY_UID.Value.HasValue) ? bedStaffBO.FACILITY_UID.Value.Value.ToString() : null);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.BedStaff bedStaff, BedStaffBO bedStaffBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedStaff.BedId != null)
                    bedStaffBO.BED_UID.Value = Guid.Parse(bedStaff.BedId.extension);                
                if (bedStaff.DivisionId != null)
                    bedStaffBO.DIVISION_UID.Value = Guid.Parse(bedStaff.DivisionId.extension);                
                bedStaffBO.STAFF.Value = bedStaff.Staff;
                if (bedStaff.PatientId != null)
                    bedStaffBO.PATIENT_UID.Value = System.Guid.Parse(bedStaff.PatientId.extension);                    
                if (bedStaff.FacilityId != null)
                    bedStaffBO.FACILITY_UID.Value = Guid.Parse(bedStaff.FacilityId.extension);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
