﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;

namespace BMS.Translators
{
    public static class TranslatorBedOccupancyCount
    {
        public static void CopyTo(this BedOccupancyCountBO bedOccupancyCountBO, DataContracts.BedOccupancyCount bedOccupancyCount)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedOccupancyCount.IsOccupiedBed = bedOccupancyCountBO.IS_OCCUPIED_BED.Value;
                bedOccupancyCount.IsUnavailableBed = bedOccupancyCountBO.IS_UNAVAILABLE_BED.Value;
                bedOccupancyCount.BedId = TranslatorUtils.BuildIdentifier(bedOccupancyCountBO.B_DOMAIN_ID, bedOccupancyCountBO.BED_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

    }
}
