﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Security.Configuration;
using System.Data.SqlClient;
using System.Transactions;
using System.IO;
using System.Xml;

namespace BMS.Security.DurableIssuedToken
{
    /// <summary>
    /// IssuedTokenCache implementation using an SQL database.
    /// </summary>
    class DatabaseIssuedTokenCache : IssuedTokenCacheBase
    {
        /// <summary>
        /// SQL connection string.
        /// </summary>
        String _connectionString;
        /// <summary>
        /// TransactionOptions used when calling the stored procedures.
        /// </summary>
        TransactionOptions _transactionOptions = new TransactionOptions();


        public DatabaseIssuedTokenCache(IDurableIssuedTokenConfiguration configuration)
            : base(configuration)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _connectionString = configuration.ConnectionString;
                _transactionOptions.IsolationLevel = configuration.IsolationLevel;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override void AddToken(IssuedTokenCacheBase.Key key, System.IdentityModel.Tokens.GenericXmlSecurityToken token)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SqlParameter param1, param2;
                param1 = new SqlParameter()
                {
                    DbType = System.Data.DbType.String,
                    ParameterName = "@SESSION_ID",
                    Value = key.SessionId

                };

                using (MemoryStream ms = new MemoryStream())
                {
                    this.SerializeCachedToken(ms, key.SessionId, token);
                    ms.Flush();
                    ms.Seek(0, SeekOrigin.Begin);
                    StreamReader sr = new StreamReader(ms);
                    param2 = new SqlParameter()
                    {
                        DbType = System.Data.DbType.String,
                        ParameterName = "@TOKEN",
                        Value = sr.ReadToEnd()
                    };
                    sr.Close();
                };

                using (SqlConnection con = new SqlConnection(_connectionString))
                {
                    using (TransactionScope ts = new TransactionScope(TransactionScopeOption.Required, _transactionOptions))
                    {
                        SqlCommand com = new SqlCommand("usp_Insert_Security_Token", con);
                        com.CommandType = System.Data.CommandType.StoredProcedure;
                        com.Parameters.Add(param1);
                        com.Parameters.Add(param2);

                        con.Open();
                        com.ExecuteNonQuery();
                        ts.Complete();
                        con.Close();
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override bool TryGetToken(IssuedTokenCacheBase.Key key, out System.IdentityModel.Tokens.GenericXmlSecurityToken cachedToken)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SqlParameter param1;
                param1 = new SqlParameter()
                {
                    DbType = System.Data.DbType.String,
                    ParameterName = "@SESSION_ID",
                    Value = key.SessionId
                };
                bool result = false;
                cachedToken = null;

                using (SqlConnection con = new SqlConnection(_connectionString))
                {
                    using (TransactionScope ts = new TransactionScope(TransactionScopeOption.Required, _transactionOptions))
                    {
                        SqlCommand com = new SqlCommand("usp_Get_Security_Token", con);
                        com.CommandType = System.Data.CommandType.StoredProcedure;

                        com.Parameters.Add(param1);
                        con.Open();
                        SqlDataReader dr = com.ExecuteReader();
                        if (dr.Read())
                        {
                            result = true;
                            using (MemoryStream ms = new MemoryStream())
                            {
                                StreamWriter sw = new StreamWriter(ms);
                                sw.Write(dr["TOKEN"]);
                                sw.Flush();
                                ms.Seek(0, SeekOrigin.Begin);
                                this.DeserializeCachedToken(ms, key, out cachedToken);
                                sw.Close();
                            }
                        }
                        dr.Close();
                        ts.Complete();
                        con.Close();
                    }
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override void RemoveToken(IssuedTokenCacheBase.Key key)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SqlParameter param1;
                param1 = new SqlParameter()
                {
                    DbType = System.Data.DbType.String,
                    ParameterName = "@SESSION_ID",
                    Value = key.SessionId
                };

                using (SqlConnection con = new SqlConnection(_connectionString))
                {
                    using (TransactionScope ts = new TransactionScope(TransactionScopeOption.Required, _transactionOptions))
                    {
                        SqlCommand com = new SqlCommand("usp_Delete_Security_Token", con);
                        com.CommandType = System.Data.CommandType.StoredProcedure;

                        com.Parameters.Add(param1);

                        con.Open();
                        com.ExecuteNonQuery();
                        ts.Complete();
                        con.Close();
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override string TryGetUserSidFromToken(IssuedTokenCacheBase.Key key)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SqlParameter param1;
                param1 = new SqlParameter()
                {
                    DbType = System.Data.DbType.String,
                    ParameterName = "@SESSION_ID",
                    Value = key.SessionId
                };
                string result = null;

                using (SqlConnection con = new SqlConnection(_connectionString))
                {
                    using (TransactionScope ts = new TransactionScope(TransactionScopeOption.Required, _transactionOptions))
                    {
                        SqlCommand com = new SqlCommand("usp_Get_Security_Token", con);
                        com.CommandType = System.Data.CommandType.StoredProcedure;

                        com.Parameters.Add(param1);
                        con.Open();
                        SqlDataReader dr = com.ExecuteReader();
                        if (dr.Read())
                        {                            
                            using (MemoryStream ms = new MemoryStream())
                            {
                                StreamWriter sw = new StreamWriter(ms);
                                sw.Write(dr["TOKEN"]);
                                sw.Flush();
                                ms.Seek(0, SeekOrigin.Begin);

                                XmlReaderSettings settings = new XmlReaderSettings();
                                settings.DtdProcessing = DtdProcessing.Prohibit;
                                settings.XmlResolver = null;
                                XmlReader reader = XmlReader.Create(ms, settings);
                                //System.Xml.XmlTextReader reader = new System.Xml.XmlTextReader(ms);
                                try
                                {
                                    while (reader.Read())
                                    {
                                        if (reader.Name.Equals("Attribute") && reader.HasAttributes)
                                        {
                                            if (reader.GetAttribute("Name").Equals("UserSID"))
                                            {
                                                result = reader.ReadElementString();
                                                break;                                                
                                            }
                                        }
                                    }
                                }
                                catch (System.Xml.XmlException)
                                {
                                    result = null;
                                }
                                finally { reader.Close(); }
                                sw.Close();
                            }
                        }
                        dr.Close();
                        ts.Complete();
                        con.Close();
                    }
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
