﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace BMS.Host
{
    /// <summary>
    /// ThreadPoolState class used to start/stop services in a ThreadPool.
    /// </summary>
    class BMSThreadPoolState
    {
        /// <summary>
        /// Type used to instantiate the ServiceHostBase
        /// </summary>
        internal Type ImplementedType { get; set; }
        /// <summary>
        /// A handle used when stopping the services via a ThreadPool to tell the main Thread what to wait for
        /// </summary>
        internal ManualResetEvent StopHandle { get; set; }
        /// <summary>
        /// Whether the service is a workflow service or a regular WCF service. 
        /// </summary>
        internal bool IsWFService { get; set; }

        internal BMSThreadPoolState(ManualResetEvent stopHandle)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                StopHandle = stopHandle;
                IsWFService = false;
                ImplementedType = null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        internal BMSThreadPoolState(Type implementedType, bool isWFService)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ImplementedType = implementedType;
                StopHandle = null;
                IsWFService = isWFService;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        internal BMSThreadPoolState(Type implementedType, ManualResetEvent stopHandle = null)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ImplementedType = implementedType;
                StopHandle = stopHandle;
                IsWFService = false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
