﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Service;
using BMS.Facade.Data;
using BMS.ServicesWrapper.BMService;
using BMS.DataContracts;
using BMS.Utils;
using BMS.ServicesWrapper.Security;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Implementation
{
    public class NewEventOperationsImplementation : INewEventOperations
    {
        public List<NewEventInfo> GetNewEvents(string wardUidList, Guid facilityIdentifier, int timeZoneMinutesOffset, string fullUserName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<NewEventInfo> result = new List<NewEventInfo>();

                IList<BMS.DataContracts.NewEvent> serviceContractList = BMSFactory.BedManagerQueryClient.GetNewEvents(wardUidList, facilityIdentifier, timeZoneMinutesOffset);
                NewEventInfo facadeContract = null;
                foreach (BMS.DataContracts.NewEvent newEvent in serviceContractList)
                {
                    facadeContract = new NewEventInfo()
                    {
                        EventCount = newEvent.EventCount,
                        EventName = newEvent.EventName,
                        Report = (newEvent.EventCount == 0) ? null : GetReport(newEvent.EventName, fullUserName)
                    };
                    result.Add(facadeContract);
                }
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public int GetCountNewEvents(string wardUidList, Guid facilityIdentifier, List<Module> flags, int timeZoneMinutesOffset)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<DataContracts.NewEvent> events = BMSFactory.BedManagerQueryClient.GetNewEvents(wardUidList, facilityIdentifier, timeZoneMinutesOffset).ToList();
                int total = events[0].TotalCount;
                string domain = SecurityFactory.Instance.GetCurrentDomain();                
                foreach (Module m in flags)
                {
                    switch (m.Code)
                    {
                        case Constants.ADM_ORD:
                                if (m.CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                                    total = total - events.Where(a => a.EventName == Utils.NewEvent.SignedAdmission).FirstOrDefault().EventCount;                            
                            break;
                        case Constants.ANTIC_DISCH:
                            if (m.CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.SignedAnticipatedDischarge).FirstOrDefault().EventCount;
                            break;
                        case Constants.DISCH_ORD:
                            if (m.CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.SignedDischarge).FirstOrDefault().EventCount;
                            break;
                        case Constants.TRSF_ORD:
                            if (m.CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.SignedTransfer).FirstOrDefault().EventCount;
                            break;
                        case Constants.DISCHARGE_APPOINTMENT:
                            if (m.CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.DischargeAppointment).FirstOrDefault().EventCount;
                            break;
                        case Constants.EMS_MODULE:
                            if (m.CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.VacatedBed).FirstOrDefault().EventCount;
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.CurrentlyCleaningBed).FirstOrDefault().EventCount;
                                total = total - events.Where(a => a.EventName == Utils.NewEvent.CompletedCleaningBed).FirstOrDefault().EventCount;
                            }
                            break;
                    }
                }
                return total;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Gets the report URL.
        /// </summary>
        /// <param name="name">The report name.</param>
        /// <returns></returns>
        private static IReportInfo GetReport(BMS.Utils.NewEvent eventName, string fullUserName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string name = string.Empty;
                IReportInfo report = null;

                switch (eventName)
                {
                    case Utils.NewEvent.SignedAdmission:
                        name = Constants.SignedAdmission;
                        break;
                    case Utils.NewEvent.AdmittedPatient:
                        name = Constants.PatientMovementByDate;
                        break;
                    case Utils.NewEvent.SignedDischarge:
                        name = Constants.SignedDischarge;
                        break;
                    case Utils.NewEvent.SignedAnticipatedDischarge:
                        name = Constants.AnticipatedDischarge;
                        break;
                    case Utils.NewEvent.DischargeAppointment:
                        name = Constants.DischargeAppointment1;
                        break;
                    case Utils.NewEvent.PatientDischarged:
                        name = Constants.PatientMovementByDate;
                        break;
                    case Utils.NewEvent.VacatedBed:
                    case Utils.NewEvent.CurrentlyCleaningBed:
                    case Utils.NewEvent.CompletedCleaningBed:
                        name = Constants.BED_TURNAROUND_TIME_REPORT;
                        break;
                    case Utils.NewEvent.BedOutOfService:
                        name = Constants.BedsOutOfService;
                        break;
                    case Utils.NewEvent.BackToService:
                        name = Constants.BedsOutOfService;
                        break;
                    case Utils.NewEvent.SignedTransfer:
                        name = Constants.ACTIVE_TRANSFER_REPORT;
                        break;
                    default:
                        name = string.Empty;
                        break;
                }


                if (!string.IsNullOrEmpty(name))
                {
                    ReportsOperationsImplementation reportOperations = new ReportsOperationsImplementation();
                    report = reportOperations.GetReports(fullUserName).Where(a => a.Name == name).FirstOrDefault().Clone();
                }
                return report;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
