﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Facade.Data
{
    public class PermissionFacility
    {
        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        public Facility Facility { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [read access].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [read access]; otherwise, <c>false</c>.
        /// </value>
        public bool ReadAccess { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the user has whiteboard write access for this facility.
        /// </summary>
        /// <value>
        ///   <c>true</c> if user has whiteboard write access for this facility; otherwise, <c>false</c>.
        /// </value>
        public bool WriteAccessWhiteboard { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [write access].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [write access]; otherwise, <c>false</c>.
        /// </value>
        public bool WriteAccess { get; set; }

        
    }
}
