using System.Collections.Generic;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Facility Settings class - stores the configuration data about the facility
    /// </summary>
    [DataContract]
    public class FacilitySettings
    {
        /// <summary>
        /// Gets or sets the name of the facility.
        /// </summary>
        /// <value>
        /// The name of the facility.
        /// </value>
        [DataMember]
        public string FacilityName { get; set; }

        /// <summary>
        /// Gets or sets the BMS server time zone.
        /// </summary>
        /// <value>
        /// The BMS server time zone.
        /// </value>
        [DataMember]
        public string BMSServerTimeZone { get; set; }

        /// <summary>
        /// Gets or sets the facility site time zone.
        /// </summary>
        /// <value>
        /// The facility site time zone.
        /// </value>
        [DataMember]
        public CD FacilitySiteTimeZone { get; set; }

        /// <summary>
        /// Gets or sets the auto removal waiting list.
        /// </summary>
        /// <value>
        /// The auto removal waiting list.
        /// </value>
        [DataMember]
        public CD AutoRemovalWaitingList { get; set; }

        /// <summary>
        /// Gets or sets the auto placement of transfers onto PPBP list.
        /// </summary>
        /// <value>
        /// The auto removal waiting list.
        /// </value>
        [DataMember]
        public CD AutoPlacementTransferList { get; set; }

        /// <summary>
        /// Gets or sets the integrated facility.
        /// </summary>
        /// <value>
        /// The integrated facility.
        /// </value>
        [DataMember]
        public CD IntegratedFacility { get; set; }

        /// <summary>
        /// Gets or sets the medical center ID.
        /// </summary>
        /// <value>
        /// The medical center ID.
        /// </value>
        [DataMember]
        public string MedicalCenterID { get; set; }

        /// <summary>
        /// Gets or sets the ward prefix.
        /// </summary>
        /// <value>
        /// The ward prefix.
        /// </value>
        [DataMember]
        public string WardPrefix { get; set; }

        /// <summary>
        /// Gets or sets the ward suffix.
        /// </summary>
        /// <value>
        /// The ward suffix.
        /// </value>
        [DataMember]
        public string WardSuffix { get; set; }

        /// <summary>
        /// Gets or sets the ADT prefix.
        /// </summary>
        /// <value>
        /// The ADT prefix.
        /// </value>
        [DataMember]
        public string ADTPrefix { get; set; }

        /// <summary>
        /// Gets or sets the ADT suffix.
        /// </summary>
        /// <value>
        /// The ADT suffix.
        /// </value>
        [DataMember]
        public string ADTSuffix { get; set; }

        /// <summary>
        /// Gets or sets the facility address1.
        /// </summary>
        /// <value>
        /// The facility address1.
        /// </value>
        [DataMember]
        public string FacilityAddress1 { get; set; }

        /// <summary>
        /// Gets or sets the facility address2.
        /// </summary>
        /// <value>
        /// The facility address2.
        /// </value>
        [DataMember]
        public string FacilityAddress2 { get; set; }

        /// <summary>
        /// Gets or sets the local time adjust settings of the facility.
        /// </summary>
        /// <value>
        /// The number of hours.
        /// </value>
        [DataMember]
        public int LocalTimeAdjust { get; set; }

        /// <summary>
        /// Gets or sets the first Site Alias for this facility.
        /// </summary>
        [DataMember]
        public string SiteAlias1 { get; set; }

        /// <summary>
        /// Gets or sets the second Site Alias for this facility.
        /// </summary>
        [DataMember]
        public string SiteAlias2 { get; set; }

        /// <summary>
        /// Gets or sets the third Site Alias for this facility.
        /// </summary>
        [DataMember]
        public string SiteAlias3 { get; set; }

        /// <summary>
        /// Gets or sets the EMS Mail Sender for this facility.
        /// </summary>
        [DataMember]
        public string EMSMailSender { get; set; }

        /// <summary>
        /// Gets or sets the Event Mail Sender for this facility.
        /// </summary>
        [DataMember]
        public string EventMailSender { get; set; }

        /// <summary>
        /// Gets or sets the BP Mail Monitor for this facility.
        /// </summary>
        [DataMember]
        public string BPMailMonitor { get; set; }

        /// <summary>
        /// Gets or sets the sister sites group.
        /// </summary>
        /// <value>
        /// The sister sites group.
        /// </value>
        [DataMember]
        public IList<SisterSitesGroup> SisterSitesGroups { get; set; }

        /// <summary>
        /// Gets or sets the Integrated Site List of the facility.
        /// </summary>
        /// <value>
        /// A comma separated list of site codes.
        /// </value>
        [DataMember]
        public string IntegratedSiteSisterList { get; set; }

        /// <summary>
        /// Gets or sets the integrated sister group id.
        /// </summary>
        /// <value>
        /// The integrated sister group id.
        /// </value>
        [DataMember]
        public int IntegratedSiteSisterGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the EMS default user.
        /// </summary>
        /// <value>
        /// The name of the EMS default user.
        /// </value>
        [DataMember]
        public string EMSDefaultUserName { get; set; }

        /// <summary>
        /// Gets or sets the EMS default password.
        /// </summary>
        /// <value>
        /// The EMS default password.
        /// </value>
        [DataMember]
        public string EMSDefaultPwd { get; set; }

        /// <summary>
        /// Gets or sets the name of the Kiosk default user.
        /// </summary>
        /// <value>
        /// The name of the Kiosk default user.
        /// </value>
        [DataMember]
        public string KioskDefaultUserName { get; set; }

        /// <summary>
        /// Gets or sets the Kiosk default password.
        /// </summary>
        /// <value>
        /// The Kiosk default password.
        /// </value>
        [DataMember]
        public string KioskDefaultPwd { get; set; }

    }
}
