﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Date view class used on the national and regional page.
    /// </summary>
    public class DateView
    {
        /// <summary>
        /// Gets or sets the region number.
        /// </summary>
        /// <value>
        /// The region code.
        /// </value>
        public string RegionNumber { get; set; }

        public string RegionDisplay { get { return "Region " + RegionNumber; } }

        /// <summary>
        /// Gets or sets the VISN number.
        /// </summary>
        /// <value>
        /// The VISN code.
        /// </value>
        public string VisnNumber { get; set; }

        public string VisnDisplay { get { return "VISN " + VisnNumber; } }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public II PatientId { get; set; }

        public string ExtensionPatientId { get { return PatientId.extension; } }

        public string IdExtension { get { return ExtensionPatientId; } }
        
        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient SSN.
        /// </summary>
        /// <value>
        /// The patient SSN.
        /// </value>
        public string PatientLastFourDigitsOfSSN { get; set; }

        /// <summary>
        /// Gets or sets the request date.
        /// </summary>
        /// <value>
        /// The request date.
        /// </value>
        public DateTime? RequestDate { get; set; }

        /// <summary>
        /// Gets or sets the disposition date.
        /// </summary>
        /// <value>
        /// The disposition date.
        /// </value>
        public DateTime? DispositionDate { get; set; }

        /// <summary>
        /// Gets or sets the entry facility.
        /// </summary>
        /// <value>
        /// The entry facility.
        /// </value>
        public string EntryFacilityName { get; set; }

        /// <summary>
        /// Gets or sets the admitted facility.
        /// </summary>
        /// <value>
        /// The admitted facility.
        /// </value>
        public string AdmittedFacilityName { get; set; }

        /// <summary>
        /// Gets or sets the enter by.
        /// </summary>
        /// <value>
        /// The enter by.
        /// </value>
        public string EnterBy { get; set; }

        /// <summary>
        /// Gets or sets the entry DT.
        /// </summary>
        /// <value>
        /// The entry DT.
        /// </value>
        public DateTime EntryDT { get; set; }

        public string EntryDTDisplay { get { return String.Format("{0} {1}", String.Format("{0:G}", EntryDT), FacilityFromTimeZoneCode); } }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        public DateTime? LastEditDate { get; set; }

        public string LastEditDateDisplay { get { return String.Format("{0} {1}", String.Format("{0:G}", LastEditDate), FacilityFromTimeZoneCode); } }

        /// <summary>
        /// Gets or sets the waiting time.
        /// </summary>
        /// <value>
        /// The wait time.
        /// </value>
        public TimeSpan WaitingTime { get; set; }

        public string WaitingTimeDisplay { get { return String.Format("{0:00}:{1:00}", (int)WaitingTime.TotalHours, WaitingTime.Minutes); } }

        /// <summary>
        /// Gets or sets the speciality.
        /// </summary>
        /// <value>
        /// The speciality.
        /// </value>
        public string Specialty { get; set; }

        /// <summary>
        /// Gets or sets the total count.
        /// </summary>
        /// <value>
        /// The total count.
        /// </value>
        public int TotalCount { get; set; }

        /// <summary>
        /// Gets or sets the index of the record(used for paging).
        /// </summary>
        /// <value>
        /// The index.
        /// </value>
        public int Index { get; set; }

        /// <summary>
        /// Gets or sets the facility from.
        /// </summary>
        /// <value>
        /// The facility from.
        /// </value>
        public Place FacilityFrom { get; set; }

        /// <summary>
        /// Gets or sets the facility to.
        /// </summary>
        /// <value>
        /// The facility to.
        /// </value>
        public Place FacilityTo { get; set; }

        /// <summary>
        /// Gets or sets the facility from time zone code.
        /// </summary>
        /// <value>
        /// The facility from time zone code.
        /// </value>
        public string FacilityFromTimeZoneCode { get; set; }

        /// <summary>
        /// Gets or sets the facility to time zone code.
        /// </summary>
        /// <value>
        /// The facility to time zone code.
        /// </value>
        public string FacilityToTimeZoneCode { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        public bool IsNationalWaitList { get; set; }

        public string IsNationalWaitListDisplay { get { return IsNationalWaitList ? "YES" : "NO"; } }

        public bool HasSimilarNameOrSSN { get; set; }
    }
}
