﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Main entity for all documents ( HL7 ACT ).
    /// </summary>
    [DataContract]
    public class Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [DataMember]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public Patient Patient { get; set; }

        /// <summary>
        /// Gets or sets the creation date.
        /// </summary>
        /// <value>
        /// The creation date.
        /// </value>
        [DataMember]
        public DateTime? CreationDate { get; set; }

        /// <summary>
        /// Gets or sets the canceled date.
        /// </summary>
        /// <value>
        /// The canceled date.
        /// </value>
        [DataMember]
        public DateTime? CanceledDate { get; set; }

        /// <summary>
        /// Gets or sets the parent.
        /// </summary>
        /// <value>
        /// The parent.
        /// </value>
        [DataMember]
        public Act Parent { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        [DataMember]
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the flow id.
        /// </summary>
        /// <value>
        /// The flow id.
        /// </value>
        [DataMember]
        public Guid FlowId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [DataMember]
        public II PatientId { get; set; }

        #endregion
    }
}
