﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class TypeOfMovementController : Controller
    {
        #region Get Methods
        // GET: /TypeOfMovement/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<TYPE_OF_MOVEMENT> list = new List<TYPE_OF_MOVEMENT>();
                foreach (TYPE_OF_MOVEMENT move in db.TYPE_OF_MOVEMENT.ToList())
                {
                    list.Add(move);
                }
                return View(list);
            }
        }

        //Get: /TypeOfMovement/Create
        public ActionResult Create()
        {
            return View();
        }

        // GET: /TypeOfMovement/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.TYPE_OF_MOVEMENT.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /TypeOfMovement/Create
        [HttpPost]
        public ActionResult Create(TYPE_OF_MOVEMENT move)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.TYPE_OF_MOVEMENT.Add(move);
                    db.SaveChanges();
                }

                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, TYPE_OF_MOVEMENT move)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(move).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
