﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;
using VistATool.Utils;

namespace VistATool.Controllers
{
    public class ScheduledAdmissionController : Controller
    {
        #region Get Methods
        // GET: /ScheduledAdmission/

        public ActionResult Index()
        {
            WorkflowViewModel model = new WorkflowViewModel();
            FillScheduledWorkflowList(model);
            return View(model);
        }

        // GET: /ScheduledAdmission/Create/
        public ActionResult Create()
        {
            WorkflowViewModel model = new WorkflowViewModel();
            FillModel(model);
            model.InternalUid = Guid.NewGuid().ToString();
            model.IsEnableScheduledAdmission = true;
            model.IsEnabledEvent = false;
            return View(model);
        }

        #endregion

        #region Post Methods

        // POST: /ScheduledAdmission/Create
        [HttpPost]
        public ActionResult Create(WorkflowViewModel model, string btnSaveScheduledAdmission, string btnSavePatientMovement)
        {
            bool IsSaved = false;
            if (model.FillBeds != null || model.FillWards != null)
            {
                FillModel(model);
                return View(model);
            }
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    if (!string.IsNullOrEmpty(btnSaveScheduledAdmission))
                    {
                        model.ScheduledAdmission.INTERNAL_UID = Guid.Parse(model.InternalUid);
                        if (model.IsSurgeryScheduledAdmission)
                            model.ScheduledAdmission.SURGERY = "Yes";
                        else
                            model.ScheduledAdmission.SURGERY = "No";
                        if (model.ScheduledAdmission.IEN == 0)
                            db.SCHEDULED_ADMISSION.Add(model.ScheduledAdmission);
                        else
                            db.Entry(model.ScheduledAdmission).State = System.Data.EntityState.Modified;

                        double value = 0;
                        if (model.ScheduledAdmission.RESERVATION_DATETIME != null && double.TryParse(model.ScheduledAdmission.RESERVATION_HOUR, out value))
                            model.ScheduledAdmission.RESERVATION_DATETIME = model.ScheduledAdmission.RESERVATION_DATETIME.Value.AddHours(value);

                        if (model.ScheduledAdmission.RESERVATION_DATETIME != null && double.TryParse(model.ScheduledAdmission.RESERVATION_MINUTE, out value))
                            model.ScheduledAdmission.RESERVATION_DATETIME = model.ScheduledAdmission.RESERVATION_DATETIME.Value.AddMinutes(value);
                    }

                    if (!string.IsNullOrEmpty(btnSavePatientMovement))
                    {
                        if (model.ScheduledAdmission.IEN == 0)
                        {
                            ModelState.AddModelError("MessageIfUserWantsToCreateEventBeforeRequest", "Create Order and then Event");
                            FillModel(model);
                            return View(model);
                        }
                        else
                        {
                            if (model.PatientMovement.ROOM_BED_ID == 0)
                            {
                                ModelState.AddModelError("PatientMovement.ROOM_BED_ID", "The BED field is required.");
                                FillModel(model);
                                return View(model);
                            }
                            if (model.PatientMovement.WARD_LOCATION_ID == 0)
                            {
                                ModelState.AddModelError("PatientMovement.WARD_LOCATION_ID", "The WARD LOCATION field is required.");
                                FillModel(model);
                                return View(model);
                            }

                            if (model.PatientMovement.TYPE_OF_MOVEMENT_ID == 0)
                            {
                                ModelState.AddModelError("PatientMovement.TYPE_OF_MOVEMENT_ID", "The TYPE OF MOVEMENT field is required.");
                                FillModel(model);
                                return View(model);
                            }

                            if (model.ScheduledAdmission != null)
                            {
                                if (string.IsNullOrEmpty(model.ScheduledAdmission.SURGERY) || model.ScheduledAdmission.SURGERY == "No")
                                    model.IsSurgeryScheduledAdmission = false;
                                else
                                    model.IsSurgeryScheduledAdmission = true;
                            }
                            model.PatientMovement.PATIENT_ID = model.ScheduledAdmission.PATIENT_ID;
                            model.PatientMovement.ENTERED_ON_DATETIME = DateTime.Now;
                            model.PatientMovement.TRANSACTION_ = "1";
                            model.PatientMovement.INTERNAL_UID = Guid.Parse(model.InternalUid);
                            if (model.PatientMovement.IEN == 0)
                                db.Entry(model.PatientMovement).State = System.Data.EntityState.Added;
                            else
                                db.Entry(model.PatientMovement).State = System.Data.EntityState.Modified;

                            double value = 0;
                            if (model.PatientMovement.DATETIME != null && double.TryParse(model.PatientMovement.DATETIME_HOUR, out value))
                                model.PatientMovement.DATETIME = model.PatientMovement.DATETIME.Value.AddHours(value);

                            if (model.PatientMovement.DATETIME != null && double.TryParse(model.PatientMovement.DATETIME_MINUTE, out value))
                                model.PatientMovement.DATETIME = model.PatientMovement.DATETIME.Value.AddMinutes(value);
                        }
                    }
                    db.SaveChanges();
                    IsSaved = true;
                    ModelState.Clear();
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                IsSaved = false;
            }

            if (!string.IsNullOrEmpty(btnSaveScheduledAdmission))
            {
                if (!IsSaved)
                {
                    model.IsEnableScheduledAdmission = true;
                    model.IsEnabledEvent = false;
                }
                else
                {
                    model.IsEnableScheduledAdmission = false;
                    model.IsEnabledEvent = true;
                }
            }

            if (!string.IsNullOrEmpty(btnSavePatientMovement))
            {
                if (!IsSaved)
                {
                    model.IsEnableScheduledAdmission = false;
                    model.IsEnabledEvent = true;
                }
                else
                {
                    model.IsEnableScheduledAdmission = false;
                    model.IsEnabledEvent = false;
                }
            }

            FillModel(model);
            return View(model);
        }


        #endregion

        #region Private Methods

        private void FillScheduledWorkflowList(WorkflowViewModel model)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                if (model.ScheduledWorkflowList == null)
                    model.ScheduledWorkflowList = new List<ScheduledAdmissionWorkflow>();

                List<SCHEDULED_ADMISSION> list = db.SCHEDULED_ADMISSION.OrderBy(a => a.PATIENT_ID).ToList();
                foreach (SCHEDULED_ADMISSION admission in list)
                {
                    ScheduledAdmissionWorkflow item = new ScheduledAdmissionWorkflow();
                    admission.PATIENT = db.PATIENTs.Find(admission.PATIENT_ID);
                    admission.NEW_PERSON = db.NEW_PERSON.Find(admission.SCHEDULER_ID);
                    admission.NEW_PERSON1 = db.NEW_PERSON.Find(admission.PROVIDER_ID);
                    admission.MEDICAL_CENTER_DIVISION = db.MEDICAL_CENTER_DIVISION.Find(admission.MEDICAL_CENTER_DIVISION_ID);
                    admission.FAC_TREAT_SPECIALTY = db.FAC_TREAT_SPECIALTY.Find(admission.TREATING_SPECIALTY_ID);
                    admission.WARD_LOCATION = db.WARD_LOCATION.Find(admission.WARD_LOCATION_ID);
                    PATIENT patient = db.PATIENTs.Where(a => a.IEN == admission.PATIENT.IEN).FirstOrDefault();
                    List<PATIENT_MOVEMENT> movements = new List<PATIENT_MOVEMENT>();
                    if (patient != null)
                    {
                        movements = patient.PATIENT_MOVEMENT.Where(a => a.TRANSACTION_ == "1" && a.INTERNAL_UID == admission.INTERNAL_UID).ToList();
                        PATIENT_MOVEMENT patMovement = movements.FirstOrDefault();
                        if (patMovement != null)
                        {
                            item.TypeOfMovementEvent = patMovement.TYPE_OF_MOVEMENT.NAME;
                            item.BedEvent = patMovement.ROOM_BED.NAME;
                            item.EventDateTime = patMovement.DATETIME.Value;
                            item.EventEnterdBy = patMovement.NEW_PERSON.NAME;
                            item.LocationEvent = patMovement.WARD_LOCATION.NAME;
                        }
                    }
                    item.ScheduledAdmission = admission;
                    model.ScheduledWorkflowList.Add(item);
                }
            }
        }

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        private void FillModel(WorkflowViewModel model)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                model.Patients = db.PATIENTs.OrderByDescending(a => a.IEN).ToList();
                model.Facilities = db.HOSPITAL_LOCATION.OrderBy(a => a.NAME).ToList();
                model.Persons = db.NEW_PERSON.OrderBy(a => a.NAME).ToList();
                model.Movements = db.TYPE_OF_MOVEMENT.OrderBy(a => a.NAME).ToList();
                model.Specialities = db.FAC_TREAT_SPECIALTY.OrderBy(a => a.NAME).ToList();
                model.Divisions = db.MEDICAL_CENTER_DIVISION.OrderBy(a => a.NAME).ToList();
                if (model.ScheduledAdmission == null)
                {
                    model.ScheduledAdmission = new SCHEDULED_ADMISSION();
                    model.ScheduledAdmission.RESERVATION_DATETIME_STRING = DateTime.Now.Date.ToString();
                    model.ScheduledAdmission.RESERVATION_HOUR = DateTime.Now.Hour.ToString();
                    model.ScheduledAdmission.RESERVATION_MINUTE = DateTime.Now.Minute.ToString();

                }
                if (model.PatientMovement == null)
                {
                    model.PatientMovement = new PATIENT_MOVEMENT();
                    model.PatientMovement.DATETIME = DateTime.Now;
                    model.PatientMovement.DATETIME_HOUR = DateTime.Now.Hour.ToString();
                    model.PatientMovement.DATETIME_MINUTE = DateTime.Now.Minute.ToString();
                }
                model.Wards = db.WARD_LOCATION.Where(a=>a.HOSPITAL_LOCATION_ID == model.HospitalLocationId).OrderBy(a => a.NAME).ToList();
                List<RMDB_WARDS_WITH_CAN_ASSIGN> wards = db.RMDB_WARDS_WITH_CAN_ASSIGN.Where(a => a.WARDS_WHICH_CAN_ASSIGN_ID == model.PatientMovement.WARD_LOCATION_ID).ToList();
                model.Beds = new List<ROOM_BED>();
                foreach (RMDB_WARDS_WITH_CAN_ASSIGN ward in wards)
                {
                    ROOM_BED roombed = db.ROOM_BED.Where(a => a.IEN == ward.ROOM_BED_ID).FirstOrDefault();
                    if (roombed != null)
                        model.Beds.Add(roombed);
                }
                model.Beds = model.Beds.OrderBy(a => a.NAME).ToList();
            }
        }
        #endregion

    }
}
