﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class OrderableItemController : Controller
    {
        #region Get Methods

        // GET: /OrderableItem/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<ORDERABLE_ITEM> list = new List<ORDERABLE_ITEM>();
                foreach (ORDERABLE_ITEM spec in db.ORDERABLE_ITEM.ToList())
                {
                    list.Add(spec);
                }
                return View(list);
            }
        }

        //Get: /OrderableItem/Create
        public ActionResult Create()
        {
            return View();
        }

        // GET: /OrderableItem/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.ORDERABLE_ITEM.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /OrderableItem/Create
        [HttpPost]
        public ActionResult Create(ORDERABLE_ITEM item)
        {
            try
            {                
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.ORDERABLE_ITEM.Add(item);
                    db.SaveChanges();
                }

                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, ORDERABLE_ITEM item)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(item).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
