﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class OrderStatusController : Controller
    {
        #region Get Methods
        // GET: /OrderStatus/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<ORDER_STATUS> list = new List<ORDER_STATUS>();
                foreach (ORDER_STATUS move in db.ORDER_STATUS.ToList())
                {
                    list.Add(move);
                }
                return View(list);
            }
        }

        //Get: /OrderStatus/Create
        public ActionResult Create()
        {
            return View();
        }

        // GET: /OrderStatus/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                return View(db.ORDER_STATUS.Find(id));
            }

        }

        #endregion

        #region Post Methods

        // POST: /OrderStatus/Create
        [HttpPost]
        public ActionResult Create(ORDER_STATUS orderStatus)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.ORDER_STATUS.Add(orderStatus);
                    db.SaveChanges();
                }

                return RedirectToAction("Index");
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, ORDER_STATUS orderStatus)
        {
            try
            {
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(orderStatus).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                return View();
            }
        }

        #endregion

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
