﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;
using System.Collections.Specialized;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using System.Configuration;
using System.Diagnostics;

namespace PerformanceTesting
{
    public class Program
    {
        public static void Main(string[] args)
        {
            //BuildXML();
            //FirstTry();
            System.Net.ServicePointManager.DefaultConnectionLimit = 1000;
            //Uri uri = new Uri("http://testaresoft2:19000/");
            //ServicePoint sp = ServicePointManager.FindServicePoint(uri);
            //sp.ConnectionLimit = 1000;

            ITestRunner testRunner = new TestRunner();
            testRunner.Load(ConfigurationManager.AppSettings[Constants.InputFile]);
            Stopwatch sw = new Stopwatch();
            sw.Start();
            testRunner.RunTest();
            //testRunner.WaitForTestEnd();
            sw.Stop();
            Utils.PrintDataToOutputFile(
                ConfigurationManager.AppSettings[Constants.OutputFile],
                ConfigurationManager.AppSettings[Constants.ResponseFile],
                ConfigurationManager.AppSettings[Constants.ErrorFile],
                ConfigurationManager.AppSettings[Constants.ExceptionFile]);
            Console.WriteLine("Test ended in {0} seconds. Press any key to continue.", ((double)sw.ElapsedMilliseconds)/1000);
            Console.ReadKey();
        }

        public static void BuildXML() 
        {
            Test test = new Test();
            test.Address = "http://testaresoft2:16000/";
            test.Clients = 10;
            test.ClientStartDelay = 500;
            test.Steps = new List<Step>();
            test.Steps.Add(new Step()
            {
                Index = 1,
                Action = "Account/LogOn",
                Command = HttpCommand.POST,
                Result = ExpectedResponse.IsLoggedOn,
                Parameters = new List<Parameter>() 
                { 
                    new Parameter("UserName", "bmsuser"),
                    new Parameter("Password", ".Password12."),
                    new Parameter("FacilityId", "C9120516-1CA1-488D-A9B7-9F7E8C5CB163"),
                    new Parameter("GoToHome", "Connect") 
                }
            });
            test.Steps.Add(new Step()
            {
                Index = 2,
                Action = "Home",
                Command = HttpCommand.GET,
                Result = ExpectedResponse.IsNotException
            });

            XmlSerializer serializer = new XmlSerializer(typeof(Test));
            FileStream stream = new FileStream("Test.xml", FileMode.Create);

            serializer.Serialize(stream, test);
            stream.Flush();
            stream.Close();
        }

        public static void FirstTry() 
        {
            DialogFactory df = new DialogFactory(address);
            IDialog dialog = df.GetDialog();

            dialog
                .Post("Account/LogOn", new NameValueCollection() { 
                                        {"UserName",  "bmsuser"},
                                        {"Password", ".Password12."},
                                        {"FacilityId", "C9120516-1CA1-488D-A9B7-9F7E8C5CB163"},
                                        {"GoToHome", "Connect"}
                                       }, Utils.IsLoggedOn)
                .Get("Home", Utils.IsNotException);
        }

        //public static readonly string address = "http://ipv4.fiddler:55817/";
        public static readonly string address = "http://testaresoft2:16000/";
        public static readonly int threadNumber = 10;
    }
}
