﻿using System;
using System.IO;
using System.Text;
using System.Security.Cryptography;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using Microsoft.SqlServer.Server;

namespace EncryptionTool
{
    public class CustomEncryption
    {
        const string str = "LgBTAHUAcABlAHIALgBTAGUAYwByAGUAdAAuAFAAQABhAHMAcwB3AG8AcgBkAC4A";

        [SqlFunction]
        public static SqlString Encrypt(SqlString input, SqlString salt)
        {
            string data = input.ToString();
            byte[] utfdata = UTF8Encoding.UTF8.GetBytes(data);
            byte[] saltBytes = UTF8Encoding.UTF8.GetBytes(salt.ToString());

            // symmetric encryption algorithm
            using (AesManaged aes = new AesManaged())
            {
                // Setting parameters
                aes.BlockSize = aes.LegalBlockSizes[0].MaxSize;
                aes.KeySize = aes.LegalKeySizes[0].MaxSize;

                // We're using the PBKDF2 standard for password-based key generation
                Rfc2898DeriveBytes rfc = new Rfc2898DeriveBytes(UTF8Encoding.Unicode.GetString(Convert.FromBase64String(str)), saltBytes);                
                aes.Key = rfc.GetBytes(aes.KeySize / 8);
                aes.IV = rfc.GetBytes(aes.BlockSize / 8);
                rfc = null;

                // Encryption
                ICryptoTransform encryptTransf = aes.CreateEncryptor();

                using (MemoryStream encryptStream = new MemoryStream())
                {
                    CryptoStream encryptor = new CryptoStream(encryptStream, encryptTransf, CryptoStreamMode.Write);

                    encryptor.Write(utfdata, 0, utfdata.Length);
                    encryptor.Flush();
                    encryptor.FlushFinalBlock();

                    byte[] encryptBytes = encryptStream.ToArray();
                    SqlString result = ConvertToAlphabetString(encryptBytes);
                    return result;
                }
            }
        }

        const int size = 52;
        private static string ConvertToAlphabetString(byte[] input)
        {
            if (input == null || input.Length == 0)
                return String.Empty;
            StringBuilder sb = new StringBuilder();
            System.Collections.IEnumerator ien = input.GetEnumerator();
            byte c1, c2;

            while (ien.MoveNext())
            {
                byte b = (byte)ien.Current;
                c1 = (byte)(b / 52);
                c2 = (byte)(b % 52);
                c1 = (byte)(c1 + 65);
                c2 = (byte)(c2 <= 25 ? c2 + 65 : c2 + 71);

                sb.Append((char)c1);
                sb.Append((char)c2);
            }
            return sb.ToString();
        }
    }
}
