SET QUOTED_IDENTIFIER OFF

DECLARE @SQL VARCHAR(MAX),  @FACILITY_CODE NVARCHAR(10), @TIME_ZONE_MINUTES_OFFSET INT, @REQ_ERA_CODE VARCHAR(100),	@REQ_ERA_DISPLAY_NAME VARCHAR(250),
		@REQ_CONTRACT_CODE VARCHAR(100), @REQ_CONTRACT_DISPLAY_NAME VARCHAR(250), @START_DATE DATETIME, @DAYLIGHT_SAVING_TIME INT, 
		@START_DATE_1 DATETIME, @END_DATE_1 DATETIME, @START_DATE_2 DATETIME, @END_DATE_2 DATETIME, @START_DATE_3 DATETIME, @END_DATE_3 DATETIME
CREATE TABLE #STRICT_DECISION(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #ERA(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #VISTA_SPECIALTY(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #DISPOSITION(CODE NVARCHAR(100), DISPLAY_NAME NVARCHAR(250))
CREATE TABLE #FACILITIES(FACILITY_UID UNIQUEIDENTIFIER, FACILITY_CODE NVARCHAR(20), FACILITY_REGION NVARCHAR(10), FACILITY_VISN NVARCHAR(10), VISTA_UID UNIQUEIDENTIFIER)
CREATE TABLE #PATIENTS(PATIENT_UID UNIQUEIDENTIFIER, PATIENT_SSN NVARCHAR(15), BMS_WAITING_LIST_RECNUM NUMERIC(18,0))

INSERT INTO #FACILITIES(FACILITY_UID, FACILITY_CODE, FACILITY_REGION, FACILITY_VISN, VISTA_UID) 
SELECT  E.IDENTIFIER, F.IDENTIFIER_EXTENSION, N_REGION.IDENTIFIER_EXTENSION, N_VISN.IDENTIFIER_EXTENSION,E_VISTA.IDENTIFIER
FROM $(varBMS_EIS).dbo.ENTITY AS E
inner join $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O on E.PK_ENTITY  = O.PFK_ORGANIZATION
INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E_VISTA ON E_VISTA.PK_ENTITY = V.FK_ENTITY
INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R_VISN ON R_VISN.FK_PLAYER_ENTITY = E_VISTA.PK_ENTITY AND R_VISN.CLASS_CODE = 'MBR'
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_UID] AS N_VISN ON R_VISN.FK_SCOPER_ENTITY = N_VISN.FK_ENTITY AND N_VISN.IDENTIFIER_ROOT = 'NUMBER'
INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R_REGION ON R_REGION.FK_PLAYER_ENTITY =  N_VISN.FK_ENTITY AND R_REGION.CLASS_CODE = 'MBR'
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_UID] AS N_REGION ON R_REGION.FK_SCOPER_ENTITY = N_REGION.FK_ENTITY AND N_REGION.IDENTIFIER_ROOT = 'NUMBER'	
WHERE O.CODE_CODE = 'FAC'

SET @FACILITY_CODE = '$(varFacilityCode)'
SET @TIME_ZONE_MINUTES_OFFSET = $(varTimeZoneMinutesOffSet)
SET @START_DATE = '$(varStartDate)'
SET @DAYLIGHT_SAVING_TIME = @TIME_ZONE_MINUTES_OFFSET - 60
SET @START_DATE_1 = '2011-03-13 02:00:00'
SET @END_DATE_1 = '2011-11-06 02:00:00'
SET @START_DATE_2 = '2012-03-11 02:00:00'
SET @END_DATE_2 = '2012-11-04 02:00:00'
SET @START_DATE_3 = '2013-03-10 02:00:00'
SET @END_DATE_3 = '2013-11-03 02:00:00'
--INSERT ERA 
SET @SQL = COALESCE(@SQL, '') + 'DECLARE @INCREMENT INT 
		SELECT @INCREMENT = MAX(CAST([uid] AS INT)) FROM $(varBMS_EVS).[dbo].[voc_nested_value_set] WHERE codingSchemeName =''Era'' AND valueSetID=''2.12.24.41'''
SELECT @SQL = @SQL + '
	SET @INCREMENT = @INCREMENT + 1
	INSERT INTO $(varBMS_EVS).[dbo].[concept] ([codingSchemeName], [conceptCode], [firstVersion], [lastVersion], [isActive], [conceptStatus], [isAnonymous], [entityDescription]) VALUES (N''Era'', N''' +  REPLACE(REPLACE(LTRIM(RTRIM(ERA.ERAName)), ' ', '_'),'''','_') + ''', 0, 0, 1, N''Active'', NULL, NULL)
	INSERT INTO $(varBMS_EVS).[dbo].[conceptProperty] ([codingSchemeName], [conceptCode], [propertyId], [property], [language], [presentationFormat], [dataType], [isPreferred], [degreeOfFidelity], [matchIfNoContext], [representationalForm], [propertyValue], [aui]) VALUES (N''Era'', N''' + REPLACE(REPLACE(LTRIM(RTRIM(ERA.ERAName)), ' ', '_'),'''','_') + ''', N''' + CAST(NEWID() AS NVARCHAR(50)) + ''', N''textualPresentation'', N''EN'', N''text/plain'', NULL, 1, NULL, NULL, NULL, N''' + UPPER(REPLACE(ERA.ERAName,'''','''''')) + ''', NULL)	
	INSERT INTO $(varBMS_EVS).[dbo].[voc_nested_value_set] ([uid], [valueSetID], [conceptCode], [nestedValueSetID], [isExpandable], [nodeType], [level], [isNestedRoot], [codingSchemeName], [fk_code_reference]) VALUES (CAST(0 as varbinary(8)) + CAST(4 as varbinary(8)) + CAST(@INCREMENT as varbinary(8)), N''2.12.24.41'', N''' + REPLACE(REPLACE(LTRIM(RTRIM(ERA.ERAName)), ' ', '_'),'''','_') + ''', N''2.12.24.41'', 0, N''L'', 1, 0, N''Era'', NULL)'
FROM $(varBMS_WAITING_LIST).[dbo].[BMS_Service_ERA] AS ERA
WHERE ERA.ERAName  NOT IN (SELECT propertyValue
FROM $(varBMS_EVS).[dbo].[conceptProperty]
WHERE codingSchemeName ='Era')
EXEC (@SQL)


CREATE TABLE #INSERT_NEW_PATIENT(ROW_NO BIGINT, ID INT, INSERT_PATIENT VARCHAR(MAX))

;WITH INSERT_PATIENT AS
(
	Select 	ROW_NUMBER() Over (Order By WL.RECNUM) As ROW_NO,
	WL.RECNUM AS ID,
	'
	SET @p2=-1
	SET @p1=-1		
	SET @PATIENT_FIRST_NAME = ''''
	SET @PATIENT_MIDDLE_INITIAL = ''''
	SET @UID = LOWER(CAST(NEWID() AS NVARCHAR(50)))
	SET @TRANSACTION_UID  = CAST(NEWID() AS NVARCHAR(50))
	SET @PATIENT_LAST_NAME = ''''
	SET @PATIENT_NAME = ''' + WL.PTNAME + '''
	'+ CASE WHEN CHARINDEX(',', WL.PTNAME ) > 0 THEN
		' 
			SET @PATIENT_FIRST_NAME = LEFT(@PATIENT_NAME, CHARINDEX('','', @PATIENT_NAME) - 1)
			SET @PATIENT_NAME = LTRIM(RTRIM(RIGHT(@PATIENT_NAME, LEN(@PATIENT_NAME) - CHARINDEX('','', @PATIENT_NAME))))
			'+
			CASE WHEN CHARINDEX(' ','@PATIENT_NAME') > 0 THEN
					' SET @PATIENT_LAST_NAME = LEFT(@PATIENT_NAME, CHARINDEX('' '', @PATIENT_NAME) - 1)
					SET @PATIENT_MIDDLE_INITIAL = RIGHT(@PATIENT_NAME, LEN(@PATIENT_NAME) - CHARINDEX('' '', @PATIENT_NAME))'
				ELSE
					'SET @PATIENT_LAST_NAME = @PATIENT_NAME
					SET @PATIENT_MIDDLE_INITIAL = '''''
			END 
	   ELSE 
		'
			SET @PATIENT_FIRST_NAME = @PATIENT_NAME
			SET @PATIENT_LAST_NAME = ''''
			SET @PATIENT_MIDDLE_INITIAL = ''''
		'	
    END +'
	'+ CASE 
		WHEN (WL.GENDER IS NULL OR WL.GENDER = 'NULL') THEN 
		' 
			SET @GENDER_CODE = ''UNK''
			SET @GENDER_DISPLAY_NAME = ''Unknown'''				
		WHEN LEFT(LTRIM(RTRIM(WL.GENDER)),1) = 'F' THEN
		' 
			SET @GENDER_CODE = ''F''
			SET @GENDER_DISPLAY_NAME = ''Female'''
		ELSE
		' 
			SET @GENDER_CODE = ''M'' 
			SET @GENDER_DISPLAY_NAME = ''Male'''				
	END	+ ' 
	exec $(varBMS_EIS).dbo.INS_ENTITY1 @IDENTIFIER=@UID,@STATUS_CODE=N''active'',@STATUS_CODE_SYSTEM=N''HL7.EntityStatus'',@STATUS_CODE_SYSTEM_NAME=N''HL7.EntityStatus'',@STATUS_DISPLAY_NAME=N''active'',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',
	@LAST_MODIFICATION_TIME= ' + CASE WHEN (WL.ENTEREDDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR (WL.ENTEREDDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR (WL.ENTEREDDT BETWEEN @START_DATE_3 AND @END_DATE_3) THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.ENTEREDDT), 120), 19) + '''' ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.ENTEREDDT), 120), 19) + '''' END + ',@TRANSACTION_ID=@TRANSACTION_UID 
	exec $(varBMS_EIS).dbo.INS_PERSON @PFK_PERSON=@p1 output,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@ENTITY_IDENTIFIER=@UID,@CODE_CODE=NULL,@CODE_CODE_SYSTEM=NULL,@CODE_CODE_SYSTEM_NAME=NULL,@CODE_DISPLAY_NAME=NULL,@DESCRIPTION=NULL,@ADMINISTRATIVE_GENDER_CODE=@GENDER_CODE,@ADMINISTRATIVE_GENDER_CODE_SYSTEM=''2.16.840.1.113883.5.1'' ,@ADMINISTRATIVE_GENDER_CODE_SYSTEM_NAME=''2.16.840.1.113883.5.1'',@ADMINISTRATIVE_GENDER_DISPLAY_NAME=@GENDER_DISPLAY_NAME,@BIRTH_TIME=NULL,@DECEASED_IND=NULL,@DECEASED_TIME=NULL,@MULTIPLE_BIRTH_IND=NULL,@MULTIPLE_BIRTH_ORDER_NUMBER=NULL,@ORGAN_DONOR_IND=NULL,@NAME_FAMILY=@PATIENT_FIRST_NAME,@NAME_FIRST_GIVEN=@PATIENT_LAST_NAME,@NAME_SECOND_GIVEN=@PATIENT_MIDDLE_INITIAL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@MARITAL_STATUS_CODE=NULL,@MARITAL_STATUS_CODE_SYSTEM=NULL,@MARITAL_STATUS_CODE_SYSTEM_NAME=NULL,@MARITAL_STATUS_DISPLAY_NAME=NULL,@EDUCATION_LEVEL_CODE=NULL,@EDUCATION_LEVEL_CODE_SYSTEM=NULL,@EDUCATION_LEVEL_CODE_SYSTEM_NAME=NULL,@EDUCATION_LEVEL_DISPLAY_NAME=NULL,@RACE_CODE=NULL,@RACE_CODE_SYSTEM=NULL,@RACE_CODE_SYSTEM_NAME=NULL,@RACE_DISPLAY_NAME=NULL,@DISABILITY_CODE=NULL,@DISABILITY_CODE_SYSTEM=NULL,@DISABILITY_CODE_SYSTEM_NAME=NULL,@DISABILITY_DISPLAY_NAME=NULL,@LIVING_ARRANGEMENT_CODE=NULL,@LIVING_ARRANGEMENT_CODE_SYSTEM=NULL,@LIVING_ARRANGEMENT_CODE_SYSTEM_NAME=NULL,@LIVING_ARRANGEMENT_DISPLAY_NAME=NULL,@RELIGIOUS_AFFILIATION_CODE=NULL,@RELIGIOUS_AFFILIATION_CODE_SYSTEM=NULL,@RELIGIOUS_AFFILIATION_CODE_SYSTEM_NAME=NULL,@RELIGIOUS_AFFILIATION_DISPLAY_NAME=NULL,@ETHNIC_GROUP_CODE=NULL,@ETHNIC_GROUP_CODE_SYSTEM=NULL,@ETHNIC_GROUP_CODE_SYSTEM_NAME=NULL,@ETHNIC_GROUP_DISPLAY_NAME=NULL,@EXISTENCE_TIME_LOW=NULL,@EXISTENCE_TIME_HIGH=NULL,@RISK_CODE=NULL,@RISK_CODE_SYSTEM=NULL,@RISK_CODE_SYSTEM_NAME=NULL,@RISK_DISPLAY_NAME=NULL,@HANDLING_CODE=NULL,@HANDLING_CODE_SYSTEM=NULL,@HANDLING_CODE_SYSTEM_NAME=NULL,@HANDLING_DISPLAY_NAME=NULL	
	exec $(varBMS_EIS).dbo.INS_ROLE @PK_ROLE=@p2 output,@PLAYER_ENTITY_IDENTIFIER=@UID,@PLAYER_DOMAIN_IDENTIFIER=N''InfoWorld'',@PLAYER_ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@SCOPER_ENTITY_IDENTIFIER=NULL,@SCOPER_DOMAIN_IDENTIFIER=NULL,@SCOPER_ENTITY_TYPE_IDENTIFIER=NULL,@CLASS_CODE=N''PAT'',@CLASS_CODE_SYSTEM=N''2.16.840.1.113883.5.110'',@CLASS_CODE_SYSTEM_NAME=N''RoleClass'',@CLASS_DISPLAY_NAME=N''patient'',@CODE_CODE=NULL,@CODE_CODE_SYSTEM=NULL,@CODE_CODE_SYSTEM_NAME=NULL,@CODE_DISPLAY_NAME=NULL,@NEGATION_IND=NULL,@NAME_FAMILY=NULL,@NAME_FIRST_GIVEN=NULL,@NAME_SECOND_GIVEN=NULL,@NAME_PREFIX=NULL,@NAME_SUFFIX=NULL,@STATUS_CODE=NULL,@STATUS_CODE_SYSTEM=NULL,@STATUS_CODE_SYSTEM_NAME=NULL,@STATUS_DISPLAY_NAME=NULL,@EFFECTIVE_TIME_LOW=NULL,@EFFECTIVE_TIME_HIGH=NULL,@CERTIFICATE_TEXT=NULL,@CONFIDENTIALITY_CODE=NULL,@CONFIDENTIALITY_CODE_SYSTEM=NULL,@CONFIDENTIALITY_CODE_SYSTEM_NAME=NULL,@CONFIDENTIALITY_DISPLAY_NAME=NULL,@QUANTITY_NUMERATOR_VALUE=NULL,@QUANTITY_NUMERATOR_UNIT=NULL,@QUANTITY_DENOMINATOR_VALUE=NULL,@QUANTITY_DENOMINATOR_UNIT=NULL,@POSITION_NUMBER=NULL,@APPROACH_SITE_CODE=NULL,@APPROACH_SITE_CODE_SYSTEM=NULL,@APPROACH_SITE_CODE_SYSTEM_NAME=NULL,@APPROACH_SITE_DISPLAY_NAME=NULL,@TARGET_SITE_CODE=NULL,@TARGET_SITE_CODE_SYSTEM=NULL,@TARGET_SITE_CODE_SYSTEM_NAME=NULL,@TARGET_SITE_DISPLAY_NAME=NULL,@GAUGE_VALUE=NULL,@GAUGE_UNIT=NULL,@JOB_CODE=NULL,@JOB_CODE_SYSTEM=NULL,@JOB_CODE_SYSTEM_NAME=NULL,@JOB_DISPLAY_NAME=NULL,@JOB_TITLE_NAME=NULL,@JOB_CLASS_CODE=NULL,@JOB_CLASS_CODE_SYSTEM=NULL,@JOB_CLASS_CODE_SYSTEM_NAME=NULL,@JOB_CLASS_DISPLAY_NAME=NULL,@OCCUPATION_CODE=NULL,@OCCUPATION_CODE_SYSTEM=NULL,@OCCUPATION_CODE_SYSTEM_NAME=NULL,@OCCUPATION_DISPLAY_NAME=NULL,@SALARY_TYPE_CODE=NULL,@SALARY_TYPE_CODE_SYSTEM=NULL,@SALARY_TYPE_CODE_SYSTEM_NAME=NULL,@SALARY_TYPE_DISPLAY_NAME=NULL,@SALARY_VALUE=NULL,@SALARY_CURRENCY=NULL,@HAZARD_EXPOSURE_TEXT=NULL,@PROTECTIVE_EQUIPMENT_TEXT=NULL,@RECERTIFICATION_TIME=NULL,@VIP_CODE=NULL,@VIP_CODE_SYSTEM=NULL,@VIP_CODE_SYSTEM_NAME=NULL,@VIP_DISPLAY_NAME=NULL,@EQUIVALENCE_IND=NULL,@DATA_TYPE=N''PAT''
	exec $(varBMS_EIS).dbo.INS_UID @FK_ENTITY=@p1,@IDENTIFIER_ROOT=''SSN'',@IDENTIFIER_EXTENSION=''' + LEFT(LTRIM(RTRIM(WL.SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(WL.SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(WL.SSN)),4)+'''
	exec $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@UID,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@TRAIT_IDENTIFIER=N''TREATING_SPECIALTY'',@TRAIT_VALUE_STRING=NULL,@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	exec $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@UID,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@TRAIT_IDENTIFIER=N''IS_VISTA_VALIDATED'',@TRAIT_VALUE_STRING=N''FALSE'',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	exec $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@UID,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@TRAIT_IDENTIFIER=N''ADMITTING_DIAGNOSIS'',@TRAIT_VALUE_STRING=NULL,@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	exec $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@UID,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@TRAIT_IDENTIFIER=N''SERVICE_CONNECTED_PERCENTAGE'',@TRAIT_VALUE_STRING= ' + CASE WHEN WL.SERVCONN IS NULL THEN 'NULL' ELSE '''' +  WL.SERVCONN + '''' END + ',@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	exec $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@UID,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@TRAIT_IDENTIFIER=N''ATTENDING_PHYSICIAN'',@TRAIT_VALUE_STRING=NULL,@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	exec $(varBMS_EIS).dbo.INS_TRAIT_VALUE @ENTITY_IDENTIFIER=@UID,@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Person'',@TRAIT_IDENTIFIER=N''IEN_LIST'',@TRAIT_VALUE_STRING=NULL,@TRAIT_VALUE_REAL=NULL,@TRAIT_VALUE_INTEGER=NULL,@TRAIT_VALUE_DATETIME=NULL,@TRAIT_VALUE_BYTE=NULL
	' AS INSERT_PATIENT
	FROM $(varBMS_WAITING_LIST).[dbo].[VISN_Bed_Control_Waiting] AS WL
	INNER JOIN (SELECT MAX(RECNUM) AS RECNUM, SSN
				FROM $(varBMS_WAITING_LIST).[dbo].[VISN_Bed_Control_Waiting]
				WHERE DISPDT IS NOT NULL AND VAHOSP = @FACILITY_CODE AND EVENTDT >= @START_DATE AND LASTEDITDT >= @START_DATE AND LEN(SSN) = 9
				GROUP BY SSN) AS PATIENT_INFO ON PATIENT_INFO.RECNUM = WL.RECNUM
	LEFT OUTER JOIN $(varBMS_EIS).dbo.EHL7_UID AS EHL7_UID1 ON EHL7_UID1.IDENTIFIER_EXTENSION = LEFT(LTRIM(RTRIM(WL.SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(WL.SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(WL.SSN)),4) AND  EHL7_UID1.IDENTIFIER_ROOT ='SSN'
	WHERE  EHL7_UID1.PK_UID IS NULL
)

INSERT INTO #INSERT_NEW_PATIENT(ROW_NO, ID, INSERT_PATIENT)
SELECT ROW_NO, ID, INSERT_PATIENT 
FROM INSERT_PATIENT
ORDER BY ID

DECLARE @LAST_INDEX INT, @LAST_INDEX_PAGE INT, @LAST_INDEX_PREV INT, @PAGE_COUNT INT, @I INT
SET @PAGE_COUNT = 500
SET @I = 1
SET @LAST_INDEX_PAGE = 0
SET @LAST_INDEX_PREV = 0
SET @SQL = NULL
SELECT @LAST_INDEX = MAX(ID) FROM #INSERT_NEW_PATIENT
WHILE (@LAST_INDEX_PAGE < @LAST_INDEX)
BEGIN
	SET @LAST_INDEX_PREV = @LAST_INDEX_PAGE
	SELECT @LAST_INDEX_PAGE = ID FROM #INSERT_NEW_PATIENT WHERE ROW_NO = @PAGE_COUNT*@I
	IF (@LAST_INDEX_PAGE = @LAST_INDEX_PREV)
		SELECT @LAST_INDEX_PAGE = MAX(ID) FROM #INSERT_NEW_PATIENT
SET @SQL =  'DECLARE  @PATIENT_LAST_NAME NVARCHAR(150), @PATIENT_FIRST_NAME NVARCHAR(300),
			@PATIENT_MIDDLE_INITIAL	NVARCHAR(100), @GENDER_CODE NVARCHAR(100), @GENDER_DISPLAY_NAME NVARCHAR(250), 
			@P1 INT, @P2 INT, @PATIENT_NAME NVARCHAR(300), @UID NVARCHAR(50), @TRANSACTION_UID NVARCHAR(50)'
SELECT @SQL = @SQL + '
		'+  NEW_PAC.INSERT_PATIENT +'
 '
FROM #INSERT_NEW_PATIENT AS NEW_PAC
WHERE NEW_PAC.ID > @LAST_INDEX_PREV AND NEW_PAC.ID <= @LAST_INDEX_PAGE
DELETE FROM #INSERT_NEW_PATIENT WHERE ID > @LAST_INDEX_PREV AND ID <= @LAST_INDEX_PAGE
SET @I = @I + 1
EXEC (@SQL)
SET @SQL = NULL
END 
DROP TABLE #INSERT_NEW_PATIENT

INSERT INTO #PATIENTS(PATIENT_UID, PATIENT_SSN, BMS_WAITING_LIST_RECNUM)
SELECT DISTINCT E.IDENTIFIER, EHL7_UID1.IDENTIFIER_EXTENSION, WL.RECNUM
FROM $(varBMS_WAITING_LIST).[dbo].[VISN_Bed_Control_Waiting] AS WL 
INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS EHL7_UID1 ON EHL7_UID1.IDENTIFIER_EXTENSION = LEFT(LTRIM(RTRIM(WL.SSN)),3) + '-' + LEFT(RIGHT(LTRIM(RTRIM(WL.SSN)),6),2) + '-' + RIGHT(LTRIM(RTRIM(WL.SSN)),4) AND  EHL7_UID1.IDENTIFIER_ROOT ='SSN'
INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON E.PK_ENTITY = EHL7_UID1.FK_ENTITY
WHERE WL.DISPDT IS NOT NULL AND WL.VAHOSP = @FACILITY_CODE AND WL.EVENTDT >= @START_DATE and WL.LASTEDITDT >= @START_DATE AND LEN(WL.SSN) = 9

INSERT INTO #STRICT_DECISION(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
	WHERE codingSchemeName = 'StrictDecision'
	
INSERT INTO #VISTA_SPECIALTY(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'VistaSpecialty'
	
INSERT INTO #ERA(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'Era'

INSERT INTO #DISPOSITION(CODE, DISPLAY_NAME)
SELECT conceptCode, propertyValue
FROM $(varBMS_EVS).dbo.conceptProperty
WHERE codingSchemeName = 'Disposition'

SELECT @REQ_ERA_CODE = CODE,
	   @REQ_ERA_DISPLAY_NAME = DISPLAY_NAME	
FROM #ERA
WHERE DISPLAY_NAME = 'OTHER'

SELECT @REQ_CONTRACT_CODE = CODE, @REQ_CONTRACT_DISPLAY_NAME = DISPLAY_NAME	
FROM #STRICT_DECISION
WHERE DISPLAY_NAME = 'NO'

CREATE TABLE #VISN_WAITING_LIST(ROW_NO BIGINT, ID NUMERIC(18,0), INSERT_VISN_WAITING VARCHAR(MAX))				

;WITH VISN_WAITING AS
(
	SELECT ROW_NUMBER() OVER (ORDER BY WL.RECNUM) AS ROW_NO,
	WL.RECNUM AS ID,
	'
	SET @REQ_ACT_ID =-1
	SET @EVN_ACT_ID =-1
	exec $(varBMS).[dbo].[usp_Insert_Transfer_Data_Migration]
	@REQ_ACT_ID = @REQ_ACT_ID OUTPUT,
	@EVN_ACT_ID = @EVN_ACT_ID OUTPUT,
	@CREATION_DATE = ' + CASE WHEN (WL.EVENTDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
							       (WL.EVENTDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
								   (WL.EVENTDT BETWEEN @START_DATE_3 AND @END_DATE_3)
							  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.EVENTDT), 120), 19) + ''''
							  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.EVENTDT), 120), 19) + '''' END + ',
	@PATIENT_UID =''' + CONVERT(NVARCHAR(50), PATIENT.PATIENT_UID) +''',
	@REQ_ERA_CODE ='+ CASE WHEN ERA.CODE IS NULL THEN '''' + @REQ_ERA_CODE + '''' ELSE '''' + ERA.CODE + '''' END + ',
	@REQ_ERA_CODE_SYSTEM =''2.12.24.41'',
	@REQ_ERA_CODE_SYSTEM_NAME =''Era'',
	@REQ_ERA_DISPLAY_NAME ='+ CASE WHEN ERA.CODE IS NULL THEN '''' + @REQ_ERA_DISPLAY_NAME + '''' ELSE '''' + REPLACE(ERA.DISPLAY_NAME, '''', '''''') + '''' END + ',		
	@REQ_FACILITY_UID ='+ CASE WHEN FACILITY.FACILITY_UID IS NULL THEN 'NULL' ELSE '''' + CONVERT(NVARCHAR(50), FACILITY.FACILITY_UID) + '''' END +',
	@REQ_DIAGNOSIS ='+ CASE WHEN WL.DIAGNOSIS IS NULL THEN 'NULL' ELSE '''' + REPLACE(WL.DIAGNOSIS,'''','''''' ) + '''' END + ',	
	@REQ_CURRENT_LOCATION ='+ CASE WHEN WL.COMMHOSP IS NULL THEN 'NULL' ELSE '''' + REPLACE(WL.COMMHOSP,'''','''''' ) + '''' END + ',	
	@REQ_COMMENTS ='+ CASE WHEN WL.COMMENTS IS NULL THEN 'NULL' ELSE '''' + REPLACE(WL.COMMENTS,'''','''''' ) + '''' END + ',	
	@REQ_CONTRACT_CODE ='+ CASE WHEN CONTRACTED.CODE IS NULL THEN '''' + @REQ_CONTRACT_CODE + '''' ELSE '''' + CONTRACTED.CODE + '''' END + ',
	@REQ_CONTRACT_CODE_SYSTEM =''2.12.24.15'',
	@REQ_CONTRACT_CODE_SYSTEM_NAME =''StrictDecision'',
	@REQ_CONTRACT_DISPLAY_NAME ='+ CASE WHEN CONTRACTED.CODE IS NULL THEN '''' + @REQ_CONTRACT_DISPLAY_NAME + '''' ELSE '''' + CONTRACTED.DISPLAY_NAME + ''''  END + ',
	@REQ_SPECIALITY_CODE ='+ CASE WHEN SPECIALTY.CODE IS NULL THEN 'NULL' ELSE '''' + SPECIALTY.CODE + '''' END + ',
	@REQ_SPECIALITY_CODE_SYSTEM	='+ CASE WHEN SPECIALTY.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.39''' END + ',
	@REQ_SPECIALITY_CODE_SYSTEM_NAME =''VistaSpecialty'',
	@REQ_SPECIALITY_DISPLAY_NAME ='+ CASE WHEN SPECIALTY.CODE IS NULL THEN 'NULL' ELSE '''' + SPECIALTY.DISPLAY_NAME + '''' END + ',
	@REQ_LOCATION_ADMISSION_DATE = ' + CASE WHEN WL.CHAdmitDT IS NULL THEN 'NULL'
									  WHEN (WL.CHAdmitDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.CHAdmitDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.CHAdmitDT BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.CHAdmitDT), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.CHAdmitDT), 120), 19) + '''' END + ',
	@REQ_FACILITY_REGION ='+ CASE WHEN FACILITY.FACILITY_UID IS NULL THEN 'NULL' ELSE '''' + FACILITY.FACILITY_REGION + '''' END +',
	@REQ_FACILITY_VISN ='+ CASE WHEN FACILITY.FACILITY_UID IS NULL THEN 'NULL' ELSE '''' + FACILITY.FACILITY_VISN+ '''' END +',
	@REQ_ENTERED_BY =' + CASE WHEN WL.ENTEREDBY IS NULL THEN 'NULL' ELSE '''' +  WL.ENTEREDBY + '''' END + ',
	@REQ_LAST_EDIT_BY =' + CASE WHEN WL.LASTEDITBY IS NULL THEN 'NULL' ELSE '''' +  WL.LASTEDITBY + '''' END + ',
	@REQ_EDITED = ' + CASE WHEN (WL.ENTEREDDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
						        (WL.ENTEREDDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
						        (WL.ENTEREDDT BETWEEN @START_DATE_3 AND @END_DATE_3)
						   THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.ENTEREDDT), 120), 19) + ''''
						   ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.ENTEREDDT), 120), 19) + '''' END + ',
	@REQ_REQUESTED_DATE = ' + CASE WHEN WL.REQUESTDT IS NULL THEN 'NULL'
									  WHEN (WL.REQUESTDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.REQUESTDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.REQUESTDT BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.REQUESTDT), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.REQUESTDT), 120), 19) + '''' END + ',
	@REQ_VISTA_SITE_UID ='+ CASE WHEN FACILITY.FACILITY_UID IS NULL THEN 'NULL' ELSE '''' + CONVERT(NVARCHAR(50), FACILITY.VISTA_UID)+ '''' END +',
	@EVN_DISPOSITION_CODE = '+ CASE WHEN DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''' + DISPOSITION.CODE + '''' END + ',
	@EVN_DISPOSITION_CODE_SYSTEM ='+ CASE WHEN DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''2.12.24.29''' END + ',
	@EVN_DISPOSITION_CODE_SYSTEM_NAME =''Disposition'',
	@EVN_DISPOSITION_DISPLAY_NAME ='+ CASE WHEN DISPOSITION.CODE IS NULL THEN 'NULL' ELSE '''' + DISPOSITION.DISPLAY_NAME + '''' END + ',
	@EVN_ADMISSION_FACILITY_UID	='+ CASE WHEN ADMITHOSP.FACILITY_UID IS NULL THEN 'NULL' ELSE '''' + CONVERT(NVARCHAR(50), ADMITHOSP.FACILITY_UID) + '''' END +',
	@EVN_COMMENT =' + CASE WHEN WL.DCOMMENT IS NULL THEN 'NULL' ELSE '''' + REPLACE(WL.DCOMMENT,'''','''''' ) + '''' END + ',
	@EVN_DISPOSITION_DATE =' + CASE WHEN WL.DISPDT IS NULL THEN 'NULL'
									  WHEN (WL.DISPDT BETWEEN @START_DATE_1 AND @END_DATE_1) OR
									       (WL.DISPDT BETWEEN @START_DATE_2 AND @END_DATE_2) OR
									       (WL.DISPDT BETWEEN @START_DATE_3 AND @END_DATE_3)
									  THEN '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @DAYLIGHT_SAVING_TIME, WL.DISPDT), 120), 19) + ''''
									  ELSE '''' + LEFT(CONVERT(VARCHAR, DATEADD(minute, @TIME_ZONE_MINUTES_OFFSET, WL.DISPDT), 120), 19) + '''' END + '
    ' AS INSERT_VISN_WAITING
	FROM $(varBMS_WAITING_LIST).[dbo].[VISN_Bed_Control_Waiting] AS WL
	INNER JOIN #PATIENTS AS PATIENT ON PATIENT.BMS_WAITING_LIST_RECNUM = WL.RECNUM
	INNER JOIN #FACILITIES AS FACILITY ON FACILITY.FACILITY_CODE = WL.VAHOSP
	INNER JOIN #VISTA_SPECIALTY AS SPECIALTY ON SPECIALTY.DISPLAY_NAME = WL.SPECNAMETEXT
	LEFT JOIN #ERA AS ERA ON ERA.DISPLAY_NAME = WL.ERA
	LEFT JOIN #STRICT_DECISION AS CONTRACTED ON CONTRACTED.DISPLAY_NAME = WL.CONTRACT
	LEFT JOIN #DISPOSITION AS DISPOSITION ON DISPOSITION.DISPLAY_NAME = WL.DISPOSITION
	LEFT JOIN #FACILITIES AS ADMITHOSP ON ADMITHOSP.FACILITY_CODE = WL.ADMITHOSP
	WHERE WL.DISPDT IS NOT NULL AND WL.VAHOSP = @FACILITY_CODE AND WL.EVENTDT >= @START_DATE AND WL.LASTEDITDT >= @START_DATE AND LEN(WL.SSN) = 9
)

INSERT INTO #VISN_WAITING_LIST(ROW_NO, ID, INSERT_VISN_WAITING)
SELECT ROW_NO, ID, INSERT_VISN_WAITING
FROM VISN_WAITING
ORDER BY ID

DROP TABLE #DISPOSITION
DROP TABLE #STRICT_DECISION
DROP TABLE #ERA
DROP TABLE #VISTA_SPECIALTY
DROP TABLE #FACILITIES
DROP TABLE #PATIENTS

SET @SQL = NULL
DECLARE @DATA_BASE VARCHAR(50)
SET @DATA_BASE = '$(varBMS)'
SET @SQL = 'USE ' + @DATA_BASE + '
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[usp_Insert_Transfer_Data_Migration]'') AND type in (N''P'', N''PC''))
DROP PROCEDURE [dbo].[usp_Insert_Transfer_Data_Migration]
Exec (''
CREATE PROCEDURE [dbo].[usp_Insert_Transfer_Data_Migration] 
	@REQ_ACT_ID INT OUTPUT,
	@EVN_ACT_ID INT OUTPUT,
	@CREATION_DATE DATETIME,
	@PATIENT_UID UNIQUEIDENTIFIER,
	@REQ_ERA_CODE NVARCHAR(100),
	@REQ_ERA_CODE_SYSTEM NVARCHAR(100),
	@REQ_ERA_CODE_SYSTEM_NAME NVARCHAR(100),
	@REQ_ERA_DISPLAY_NAME NVARCHAR(250),
	@REQ_FACILITY_UID UNIQUEIDENTIFIER,
	@REQ_DIAGNOSIS NVARCHAR(250),
	@REQ_CURRENT_LOCATION NVARCHAR(150),
	@REQ_COMMENTS NVARCHAR(250),
	@REQ_CONTRACT_CODE NVARCHAR(100),
	@REQ_CONTRACT_CODE_SYSTEM NVARCHAR(100),
	@REQ_CONTRACT_CODE_SYSTEM_NAME NVARCHAR(100),
	@REQ_CONTRACT_DISPLAY_NAME NVARCHAR(250),
	@REQ_SPECIALITY_CODE NVARCHAR(100),
	@REQ_SPECIALITY_CODE_SYSTEM	NVARCHAR(100),
	@REQ_SPECIALITY_CODE_SYSTEM_NAME NVARCHAR(100),
	@REQ_SPECIALITY_DISPLAY_NAME NVARCHAR(250),
	@REQ_LOCATION_ADMISSION_DATE DATETIME,
	@REQ_FACILITY_REGION NVARCHAR(100),
	@REQ_FACILITY_VISN NVARCHAR(100),
	@REQ_ENTERED_BY NVARCHAR(100) = NULL,
	@REQ_LAST_EDIT_BY NVARCHAR(100) = NULL,
	@REQ_EDITED DATETIME = NULL,
	@REQ_REQUESTED_DATE DATETIME = NULL,
	@REQ_VISTA_SITE_UID UNIQUEIDENTIFIER,
	@EVN_DISPOSITION_CODE NVARCHAR(100),
	@EVN_DISPOSITION_CODE_SYSTEM NVARCHAR(100),
	@EVN_DISPOSITION_CODE_SYSTEM_NAME NVARCHAR(100),
	@EVN_DISPOSITION_DISPLAY_NAME NVARCHAR(250),
	@EVN_ADMISSION_FACILITY_UID	UNIQUEIDENTIFIER,
	@EVN_COMMENT NVARCHAR(150),
	@EVN_DISPOSITION_DATE DATETIME = NULL

AS
BEGIN
SET NOCOUNT ON
	
	DECLARE @CONTRACT_ID INT, @ERA_ID INT, @SPECIALITY_ID INT, @DISPOSITION_ID INT, @FLOW_ID UNIQUEIDENTIFIER
	SELECT @FLOW_ID = NEWID()
	
	EXEC dbo.usp_Insert_Act
		@PATIENT_UID = @PATIENT_UID,
		@CREATION_DATE = @CREATION_DATE,
		@CANCELED_DATE = NULL,
		@PARENT_ACT_ID = NULL,
		@FLOW_ID = @FLOW_ID,
		@DOMAIN_ID = ''''InfoWorld'''',
		@IEN = NULL,
		@ID = @REQ_ACT_ID OUTPUT
			
	-- CONTRACT CONCEPT EXISTENCE CHECK
	EXEC dbo.usp_Manage_Concept 
		@CODE = @REQ_CONTRACT_CODE, 
		@CODE_SYSTEM = @REQ_CONTRACT_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @REQ_CONTRACT_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @REQ_CONTRACT_DISPLAY_NAME, 
		@ID = @CONTRACT_ID  OUTPUT

	-- ERA CONCEPT EXISTENCE CHECK
	EXEC dbo.usp_Manage_Concept 
		@CODE = @REQ_ERA_CODE, 
		@CODE_SYSTEM = @REQ_ERA_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @REQ_ERA_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @REQ_ERA_DISPLAY_NAME, 
		@ID = @ERA_ID  OUTPUT

	-- SPECIALITY CONCEPT EXISTENCE CHECK
	EXEC dbo.usp_Manage_Concept 
		@CODE = @REQ_SPECIALITY_CODE, 
		@CODE_SYSTEM = @REQ_SPECIALITY_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @REQ_SPECIALITY_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @REQ_SPECIALITY_DISPLAY_NAME, 
		@ID = @SPECIALITY_ID  OUTPUT

	-- DISPOSITION CONCEPT EXISTENCE CHECK
	EXEC dbo.usp_Manage_Concept 
		@CODE = @EVN_DISPOSITION_CODE, 
		@CODE_SYSTEM = @EVN_DISPOSITION_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @EVN_DISPOSITION_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @EVN_DISPOSITION_DISPLAY_NAME, 
		@ID = @DISPOSITION_ID  OUTPUT
			
	INSERT INTO TRANSFER_REQ
	(
		ACT_ID,
		ERA_ID,
		FACILITY_UID,
		VISTA_SITE_UID,
		CONTRACT_ID,
		SPECIALITY_ID,
		DIAGNOSIS,
		CURRENT_LOCATION,
		COMMENTS,
		LOCATION_ADMISSION_DATE,
		FACILITY_REGION,
		FACILITY_VISN,
		REQUESTED_DATE,
		ENTERED_BY,
		LAST_EDIT_BY,
		EDITED,
		IS_NATIONAL_WAIT_LIST
	)
	VALUES
	(
		@REQ_ACT_ID ,
		@ERA_ID,
		@REQ_FACILITY_UID,
		@REQ_VISTA_SITE_UID,
		@CONTRACT_ID,
		@SPECIALITY_ID,
		@REQ_DIAGNOSIS,
		@REQ_CURRENT_LOCATION,
		@REQ_COMMENTS,
		@REQ_LOCATION_ADMISSION_DATE,
		@REQ_FACILITY_REGION,
		@REQ_FACILITY_VISN,
		@REQ_REQUESTED_DATE,
		@REQ_ENTERED_BY,
		@REQ_LAST_EDIT_BY,
		@REQ_EDITED,
		0
	)
	
	EXEC dbo.usp_Insert_Act
		@PATIENT_UID = @PATIENT_UID,
		@CREATION_DATE = @CREATION_DATE,
		@CANCELED_DATE = NULL,
		@PARENT_ACT_ID = @REQ_ACT_ID,
		@FLOW_ID = @FLOW_ID,
		@DOMAIN_ID = ''''InfoWorld'''',
		@IEN = NULL,
		@ID = @EVN_ACT_ID OUTPUT

	INSERT INTO TRANSFER_EVN
	(
		ACT_ID,
		COMMENT,
		ADMISSION_FACILITY_UID,
		DISPOSITION_ID,
		DISPOSITION_DATE
	)
	VALUES
	(
		@EVN_ACT_ID,
		@EVN_COMMENT,
		@EVN_ADMISSION_FACILITY_UID,
		@DISPOSITION_ID,
		@EVN_DISPOSITION_DATE					
	)	

END
'')
'
EXEC (@SQL)

SET @SQL = NULL
SET @PAGE_COUNT = 1500
SET @I = 1
SET @LAST_INDEX_PAGE = 0
SET @LAST_INDEX_PREV = 0
SELECT @LAST_INDEX = MAX(ID) FROM #VISN_WAITING_LIST
WHILE (@LAST_INDEX_PAGE < @LAST_INDEX)
BEGIN
	SET @LAST_INDEX_PREV = @LAST_INDEX_PAGE
	SELECT @LAST_INDEX_PAGE = ID FROM #VISN_WAITING_LIST WHERE ROW_NO = @PAGE_COUNT*@I
	IF (@LAST_INDEX_PAGE = @LAST_INDEX_PREV)
		SELECT @LAST_INDEX_PAGE = MAX(ID) FROM #VISN_WAITING_LIST
SET @SQL = 'DECLARE @REQ_ACT_ID INT, @EVN_ACT_ID INT'
SELECT @SQL = @SQL + '
		'+  WAITING_LIST.INSERT_VISN_WAITING +'
 '
FROM #VISN_WAITING_LIST  AS WAITING_LIST
WHERE WAITING_LIST.ID > @LAST_INDEX_PREV AND WAITING_LIST.ID <= @LAST_INDEX_PAGE
DELETE FROM #VISN_WAITING_LIST WHERE ID > @LAST_INDEX_PREV AND ID <= @LAST_INDEX_PAGE
SET @I = @I + 1
EXEC (@SQL)
SET @SQL = NULL
END 
DROP TABLE #VISN_WAITING_LIST



SET @SQL = 'USE $(varBMS)
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[usp_Insert_Transfer_Data_Migration]'') AND type in (N''P'', N''PC''))
DROP PROCEDURE [dbo].[usp_Insert_Transfer_Data_Migration]'
EXEC (@SQL)

SET QUOTED_IDENTIFIER ON