DECLARE @SLP_FLAG NVARCHAR(250), @FLT_FLAG NVARCHAR(250), @CAU_FLAG NVARCHAR(250), @RES_FLAG NVARCHAR(250), @SI_FLAG NVARCHAR(250),
		@FLU_FLAG NVARCHAR(250), @BATH_FLAG NVARCHAR(250), @TEL_FLAG NVARCHAR(250), @OPT_OUT_FLAG NVARCHAR(250), @OBSV_FLAG NVARCHAR(250),
		@HCAP_FLAG NVARCHAR(250), @LEQUIP_FLAG NVARCHAR(250), @OXY2_FLAG NVARCHAR(250), @WPROG_FLAG NVARCHAR(250), @RT_FLAG NVARCHAR(250),
		@VENT_FLAG NVARCHAR(250), @STRET_CHER_FLAG NVARCHAR(250), @ONE_FLAG NVARCHAR(250), @CLS_OBS_FLAG NVARCHAR(250),
		@NEGPRES_FLAG NVARCHAR(250), @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10), @EIS_FACILITY_ID INT, @VISTA_NAME NVARCHAR(250),
		@SLP_FLAG_ICON_ID INT, @SLP_FLAG_IS_PATIENT_ICON BIT, @FLT_FLAG_ICON_ID INT, @FLT_FLAG_IS_PATIENT_ICON BIT, @CAU_FLAG_ICON_ID INT, @CAU_FLAG_IS_PATIENT_ICON BIT,
		@RES_FLAG_ICON_ID INT, @RES_FLAG_IS_PATIENT_ICON BIT, @SI_FLAG_ICON_ID INT, @SI_FLAG_IS_PATIENT_ICON BIT, @FLU_FLAG_ICON_ID INT, @FLU_FLAG_IS_PATIENT_ICON BIT,
		@BATH_FLAG_ICON_ID INT, @BATH_FLAG_IS_PATIENT_ICON BIT, @TEL_FLAG_ICON_ID INT, @TEL_FLAG_IS_PATIENT_ICON BIT, @OPT_OUT_FLAG_ICON_ID INT, @OPT_OUT_FLAG_IS_PATIENT_ICON BIT,
		@OBSV_FLAG_ICON_ID INT, @OBSV_FLAG_IS_PATIENT_ICON BIT, @NEGPRES_FLAG_ICON_ID INT, @NEGPRES_FLAG_IS_PATIENT_ICON BIT, @HCAP_FLAG_ICON_ID INT, @HCAP_FLAG_IS_PATIENT_ICON BIT,
		@LEQUIP_FLAG_ICON_ID INT, @LEQUIP_FLAG_IS_PATIENT_ICON BIT, @OXY2_FLAG_ICON_ID INT, @OXY2_FLAG_IS_PATIENT_ICON BIT, @WPROG_FLAG_ICON_ID INT, @WPROG_FLAG_IS_PATIENT_ICON BIT,
		@RT_FLAG_ICON_ID INT, @RT_FLAG_IS_PATIENT_ICON BIT, @VENT_FLAG_ICON_ID INT, @VENT_FLAG_IS_PATIENT_ICON BIT, @STRET_CHER_FLAG_ICON_ID INT, @STRET_CHER_FLAG_IS_PATIENT_ICON BIT, 
		@ONE_FLAG_ICON_ID INT, @ONE_FLAG_IS_PATIENT_ICON BIT, @CLS_OBS_FLAG_ICON_ID INT, @CLS_OBS_FLAG_IS_PATIENT_ICON BIT

CREATE TABLE #ICON_FLAG(ID INT, IMAGE_NAME NVARCHAR(250), IS_PATIENT_ICON BIT)
CREATE TABLE #BEDS (PK INT, BED_NAME NVARCHAR(50), BED_UID UNIQUEIDENTIFIER, WARD_GROUP_NAME NVARCHAR(50))
CREATE TABLE #PATIENTS(PATIENT_UID UNIQUEIDENTIFIER, BED_UID UNIQUEIDENTIFIER, BED_NAME NVARCHAR(50))
CREATE TABLE #ACTIVE_ADMISSION(ADMISSION_ID INT NOT NULL, CREATED_DATE DATETIME NULL)
CREATE TABLE #ADMISSION_AND_TRANSFER(ADMISSION_ID INT NOT NULL, BED_UID UNIQUEIDENTIFIER, CREATED_DATE DATETIME NULL)
		
SET @FACILITY_CODE = '$(varFacilityCode)'
SET @SLP_FLAG = 'fall.png'
SET @FLT_FLAG ='flight.png'
SET @CAU_FLAG ='WBCaution.png'
SET @RES_FLAG ='buckle.png'
SET @SI_FLAG ='Suicide Risk.png'
SET @FLU_FLAG ='Flu_Risk2.png'
SET @BATH_FLAG ='Shared Bathroom (Room).png'
SET @TEL_FLAG ='Telemetry (Patient).png'
SET @OPT_OUT_FLAG ='PTOptOut.jpg'
SET @OBSV_FLAG ='Observation.jpg'
SET	@HCAP_FLAG ='Wheelchair Bound (Patient) (EM).png'
SET @LEQUIP_FLAG ='Lift Equipment (Patient) (EM).png'
SET @OXY2_FLAG ='Oxygen (Patient) (EM).png'
SET @WPROG_FLAG ='Womens Program (Room).png'
SET @RT_FLAG ='Respiratory Therapy (Patient).png'
SET	@VENT_FLAG ='Ventilator (Patient) (EM).png'
SET @STRET_CHER_FLAG ='Stretcher (Patient) (EM).png'
SET @ONE_FLAG ='oneto1.png'
SET @CLS_OBS_FLAG ='Close Observation (Patient).png'
SET @NEGPRES_FLAG ='Negative Pressure (Room).png'

SELECT @EIS_FACILITY_ID = E.PK_ENTITY, @VISTA_NAME = O_VISTA.NAME
FROM $(varBMS_EIS).dbo.ENTITY AS E 
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = F.FK_ENTITY AND R.CLASS_CODE = 'MBR'
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O_VISTA ON O_VISTA.PFK_ORGANIZATION = R.FK_SCOPER_ENTITY
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'


INSERT INTO #BEDS(PK, BED_NAME, BED_UID, WARD_GROUP_NAME)
SELECT DISTINCT BED.PFK_PLACE, BED.NAME, E.IDENTIFIER, O.NAME
FROM $(varBMS_EIS).[dbo].[EHL7_PLACE] AS BED
INNER JOIN $(varBMS_EIS).[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ORGANIZATION] AS O ON O.PFK_ORGANIZATION = R_BED.FK_SCOPER_ENTITY
WHERE BED.CODE_DISPLAY_NAME ='BED' AND R_BED.FK_SCOPER_ENTITY IN (SELECT O.[PFK_ORGANIZATION]
FROM $(varBMS_EIS).[dbo].[EHL7_ORGANIZATION] AS O
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID)


INSERT INTO #ICON_FLAG(ID, IMAGE_NAME, IS_PATIENT_ICON)
SELECT ICON.ID, ICON.IMAGE_NAME, CASE WHEN ICON.PATIENT_OR_ROOMBED = 'P' THEN 1 ELSE 0 END
FROM $(varBMS).[dbo].[ICON_FLAG] AS ICON
WHERE ICON.[GROUP] = 'WHITEBOARD_ICON' AND (ICON.SUBGROUP = 'STANDARD_ICON' OR ICON.SUBGROUP = 'EMERGENCY_ICON') 

	
--GET ACTIVE ADMISSION
--If more patients were admitted in the same bed on the whiteboard is displayed last patient admitted
INSERT INTO #ADMISSION_AND_TRANSFER(ADMISSION_ID, BED_UID, CREATED_DATE)
SELECT ADM_EVN.ID, ADM_EVN.BED_UID, ADM_EVN.ADMISSION_DATE
FROM $(varBMS).[dbo].[ADMISSION_EVN] AS ADM_EVN
	INNER JOIN #BEDS AS B ON ADM_EVN.BED_UID = B.BED_UID
WHERE ADM_EVN.HAS_DISCHARGE = 0

INSERT INTO #ADMISSION_AND_TRANSFER(ADMISSION_ID, BED_UID, CREATED_DATE)
SELECT MOV_EVN.ADMISSION_ID, MOV_EVN.BED_UID, MOV_EVN.MOVEMENT_DATE
FROM $(varBMS).[dbo].[MOVEMENT_EVN] AS MOV_EVN
	INNER JOIN (SELECT MAX(CAST(LAST_MOV_EVN.IEN as BIGINT)) AS IEN, LAST_MOV_EVN.ADMISSION_ID
				FROM $(varBMS).[dbo].[MOVEMENT_EVN] LAST_MOV_EVN
				INNER JOIN #ADMISSION_AND_TRANSFER AS ADM_EVN ON ADM_EVN.ADMISSION_ID = LAST_MOV_EVN.ADMISSION_ID
				GROUP BY LAST_MOV_EVN.ADMISSION_ID) MAX_ME_EVENT 
				ON MAX_ME_EVENT.IEN = CAST(MOV_EVN.IEN AS BIGINT) AND MAX_ME_EVENT.ADMISSION_ID = MOV_EVN.ADMISSION_ID

INSERT INTO #ACTIVE_ADMISSION(ADMISSION_ID, CREATED_DATE)
SELECT DISTINCT ADMISSION_INFO.ADMISSION_ID, ADMISSION_INFO.CREATED_DATE
FROM #ADMISSION_AND_TRANSFER AS ADMISSION_INFO
INNER JOIN 
(   SELECT MAX(CREATED_DATE) AS CREATED_DATE, BED_UID
	FROM #ADMISSION_AND_TRANSFER
	GROUP BY BED_UID
) LAST_ADMISISON_INFO ON LAST_ADMISISON_INFO.CREATED_DATE = ADMISSION_INFO.CREATED_DATE AND LAST_ADMISISON_INFO.BED_UID = ADMISSION_INFO.BED_UID

DROP TABLE #ADMISSION_AND_TRANSFER

--SELECT ADMITTED PATIENTS WITH ASSOCIATED BED
INSERT INTO #PATIENTS(PATIENT_UID, BED_UID, BED_NAME)
SELECT DISTINCT AE.PATIENT_UID, AE.BED_UID, B.BED_NAME
FROM $(varBMS).[dbo].[ADMISSION_EVN] AS AE 	
	INNER JOIN #ACTIVE_ADMISSION AS AA ON AE.ID = AA.ADMISSION_ID
	INNER JOIN #BEDS AS B ON AE.BED_UID = B.BED_UID
WHERE AE.HAS_DISCHARGE = 0 AND AE.BED_UID IS NOT NULL
	
DROP TABLE #ACTIVE_ADMISSION

;WITH DUPLICATE_BEDS (PK, BED_NAME)
AS
(
SELECT MAX(PK), BED_NAME
FROM #BEDS
WHERE BED_NAME NOT IN (SELECT DISTINCT BED_NAME FROM #PATIENTS)
GROUP BY BED_NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
WHERE DEL.PK IS NULL AND BED.BED_NAME NOT IN (SELECT DISTINCT BED_NAME FROM #PATIENTS)

;WITH DUPLICATE_OCC_BEDS (PK)
AS
(
SELECT B.PK
FROM #BEDS AS B
INNER JOIN #PATIENTS AS P ON P.BED_NAME = B.BED_NAME AND P.BED_UID <> B.BED_UID
)

DELETE BED FROM #BEDS AS BED
INNER JOIN DUPLICATE_OCC_BEDS AS DEL ON DEL.PK = BED.PK
		 
SELECT @CLS_OBS_FLAG_ICON_ID = ID, @CLS_OBS_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @CLS_OBS_FLAG

SELECT @ONE_FLAG_ICON_ID = ID, @ONE_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @ONE_FLAG

SELECT @STRET_CHER_FLAG_ICON_ID = ID, @STRET_CHER_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @STRET_CHER_FLAG

SELECT @VENT_FLAG_ICON_ID = ID, @VENT_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @VENT_FLAG

SELECT @RT_FLAG_ICON_ID = ID, @RT_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @RT_FLAG

SELECT @WPROG_FLAG_ICON_ID = ID, @WPROG_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @WPROG_FLAG

SELECT @OXY2_FLAG_ICON_ID = ID, @OXY2_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @OXY2_FLAG

SELECT @LEQUIP_FLAG_ICON_ID = ID, @LEQUIP_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @LEQUIP_FLAG

SELECT @HCAP_FLAG_ICON_ID = ID, @HCAP_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @HCAP_FLAG

SELECT @NEGPRES_FLAG_ICON_ID = ID, @NEGPRES_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @NEGPRES_FLAG

SELECT @OBSV_FLAG_ICON_ID = ID, @OBSV_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @OBSV_FLAG

SELECT @OPT_OUT_FLAG_ICON_ID = ID, @OPT_OUT_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @OPT_OUT_FLAG

SELECT @SLP_FLAG_ICON_ID = ID, @SLP_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @SLP_FLAG

SELECT @FLT_FLAG_ICON_ID = ID, @FLT_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @FLT_FLAG 

SELECT @CAU_FLAG_ICON_ID = ID, @CAU_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @CAU_FLAG 

SELECT @RES_FLAG_ICON_ID = ID, @RES_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @RES_FLAG 

SELECT @SI_FLAG_ICON_ID = ID, @SI_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @SI_FLAG 

SELECT @FLU_FLAG_ICON_ID = ID, @FLU_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @FLU_FLAG 

SELECT @BATH_FLAG_ICON_ID = ID, @BATH_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @BATH_FLAG 

SELECT @TEL_FLAG_ICON_ID = ID, @TEL_FLAG_IS_PATIENT_ICON = IS_PATIENT_ICON	
FROM #ICON_FLAG 
WHERE IMAGE_NAME = @TEL_FLAG 

CREATE TABLE #IMAGES(ROW_NO BIGINT, ID INT, INSERT_ICON_ASSOCIATION VARCHAR(MAX))

;WITH IMG AS
(
	SELECT ROW_NUMBER() Over (Order By ICON.RECNUM) As ROW_NO,
		ICON.RECNUM AS ID,
		'
		  SET @LIST_ICON_FLAG_IDS_OF_BED =''''
		  SET @LIST_ICON_FLAG_IDS_OF_PATIENT =''''
		  SET @LIST_ICON_FLAG_FACILITY_IDS_OF_BED = ''''
		  SET @LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT ='' ''
		  SET @BED_UID = ''' + CONVERT(NVARCHAR(50), BED.BED_UID) + '''
		  '+
			CASE
				WHEN PATIENT.PATIENT_UID  IS NOT NULL THEN '
					SET @PATIENT_UID = ''' + CONVERT(NVARCHAR(50),PATIENT.PATIENT_UID) + ''''
				ELSE '
						SET @PATIENT_UID = NULL '
			END +'
		  
		  IF ''' + ISNULL(ICON.SlpFlag, 'NO') + '''  = ''YES''
				 '+
					CASE
						WHEN @SLP_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @SLP_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED +  ''' + CONVERT(VARCHAR, @SLP_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'

		  IF ''' + ISNULL(ICON.FltFlag, 'NO') + ''' = ''YES''
				 '+
					CASE
						WHEN @FLT_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @FLT_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @FLT_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'

		  IF ''' + ISNULL(ICON.CauFlag, 'NO') + ''' = ''YES''
			   '+
					CASE
						WHEN @CAU_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @CAU_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @CAU_FLAG_ICON_ID) + ''' + '','' '
					END 
				+'
			 				
			IF ''' + ISNULL(ICON.ResFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @RES_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @RES_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @RES_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
				 
			IF ''' + ISNULL(ICON.SIFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @SI_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @SI_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @SI_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'

			IF ''' + ISNULL(ICON.FluFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @FLU_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @FLU_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @FLU_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'

			IF ''' + ISNULL(ICON.BATHFLAG, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @BATH_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @BATH_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @BATH_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
			
			IF ''' + ISNULL(ICON.TELFLAG, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @TEL_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @TEL_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @TEL_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
			 
			IF ''' + ISNULL(ICON.OptOutFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @OPT_OUT_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @OPT_OUT_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @OPT_OUT_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
			 					
			IF ''' + ISNULL(ICON.ObsvFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @OBSV_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @OBSV_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @OBSV_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'

		   IF ''' + ISNULL(ICON.HCapFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @HCAP_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @HCAP_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @HCAP_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
				
		   IF ''' + ISNULL(ICON.LEquipFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @LEQUIP_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @LEQUIP_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @LEQUIP_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
					
			IF ''' + ISNULL(ICON.Oxy2Flag, 'NO') + ''' = ''YES''
				 '+
					CASE
						WHEN @OXY2_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @OXY2_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @OXY2_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
				
			IF ''' + ISNULL(ICON.WProgFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @WPROG_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @WPROG_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @WPROG_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
				
			IF ''' + ISNULL(ICON.RTFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @RT_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @RT_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @RT_FLAG_ICON_ID) + ''' + '','' '
					END 
				 +'
			  
			IF ''' + ISNULL(ICON.VENTFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @VENT_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @VENT_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @VENT_FLAG_ICON_ID) + ''' + '','''
					END 
				 +'
			 				
			IF ''' + ISNULL(ICON.STRETCHERFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN  @STRET_CHER_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @STRET_CHER_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @STRET_CHER_FLAG_ICON_ID) + ''' + '','''
					END 
				 +'
				
			IF ''' + ISNULL(ICON.ONEFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @ONE_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @ONE_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @ONE_FLAG_ICON_ID) + ''' + '','''
					END 
				 +'
				
			IF ''' + ISNULL(ICON.CLSOBSFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @CLS_OBS_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @CLS_OBS_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @CLS_OBS_FLAG_ICON_ID) + ''' + '','''
					END 
				 +'
			 				
			 IF ''' + ISNULL(ICON.NEGPRESFlag, 'NO') + ''' = ''YES''
				'+
					CASE
						WHEN @NEGPRES_FLAG_IS_PATIENT_ICON = 1 THEN '
							SET @LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT + ''' + CONVERT(VARCHAR, @NEGPRES_FLAG_ICON_ID) + ''' + '','''
						ELSE '
							SET @LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED + ''' + CONVERT(VARCHAR, @NEGPRES_FLAG_ICON_ID) + ''' + '','''
					END 
				 +'					
			EXEC $(varBMS).[dbo].[usp_Insert_Icon_Association]
			@BED_UID = @BED_UID,
			@PATIENT_UID = @PATIENT_UID,
			@FACILITY_UID = NULL,
			@LIST_ICON_FLAG_IDS_OF_BED = @LIST_ICON_FLAG_IDS_OF_BED,
			@LIST_ICON_FLAG_IDS_OF_PATIENT = @LIST_ICON_FLAG_IDS_OF_PATIENT,
			@LIST_ICON_FLAG_FACILITY_IDS_OF_BED = @LIST_ICON_FLAG_FACILITY_IDS_OF_BED,
			@LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT = @LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT' AS INSERT_ICON_ASSOCIATION
		FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Whiteboard_Log] AS ICON
			INNER JOIN #BEDS AS BED ON BED.BED_NAME = ICON.VistaBed AND BED.WARD_GROUP_NAME = ICON.Ward
			LEFT JOIN #PATIENTS AS PATIENT ON PATIENT.BED_UID = BED.BED_UID
)

INSERT INTO #IMAGES(ROW_NO, ID, INSERT_ICON_ASSOCIATION)
SELECT ROW_NO, ID, INSERT_ICON_ASSOCIATION
FROM IMG
ORDER BY IMG.ID

DROP TABLE #BEDS
DROP TABLE #ICON_FLAG
DROP TABLE #PATIENTS

DECLARE @LAST_INDEX INT, @LAST_INDEX_PAGE INT, @LAST_INDEX_PREV INT, @PAGE_COUNT INT, @I INT
SET @PAGE_COUNT = 500
SET @I = 1
SET @LAST_INDEX_PAGE = 0
SET @LAST_INDEX_PREV = 0
SELECT @LAST_INDEX = MAX(ID) FROM #IMAGES
WHILE (@LAST_INDEX_PAGE < @LAST_INDEX)
BEGIN
	SET @LAST_INDEX_PREV = @LAST_INDEX_PAGE
	SELECT @LAST_INDEX_PAGE = ID FROM #IMAGES WHERE ROW_NO = @PAGE_COUNT*@I
	IF (@LAST_INDEX_PAGE = @LAST_INDEX_PREV)
		SELECT @LAST_INDEX_PAGE = MAX(ID) FROM #IMAGES
		
SET @SQL = 'DECLARE @ICON_ID INT, @IS_PATIENT_ICON BIT, @PATIENT_UID UNIQUEIDENTIFIER, 
			@BED_UID UNIQUEIDENTIFIER, @LIST_ICON_FLAG_IDS_OF_BED NVARCHAR(MAX), 
			@LIST_ICON_FLAG_IDS_OF_PATIENT NVARCHAR(MAX), 
			@LIST_ICON_FLAG_FACILITY_IDS_OF_BED NVARCHAR(MAX),
			@LIST_ICON_FLAG_FACILITY_IDS_OF_PATIENT NVARCHAR(MAX) '
SELECT @SQL = @SQL + '
		'+  ICON.INSERT_ICON_ASSOCIATION +'
 '
FROM #IMAGES  AS ICON
WHERE ICON.ID > @LAST_INDEX_PREV AND ICON.ID <= @LAST_INDEX_PAGE
DELETE FROM #IMAGES WHERE ID > @LAST_INDEX_PREV AND ID <= @LAST_INDEX_PAGE
SET @I = @I + 1
EXEC sp_executesql @SQL
SET @SQL = NULL
END 

DROP TABLE #IMAGES