DECLARE @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10), @EIS_FACILITY_ID INT, @FACILITY_UID UNIQUEIDENTIFIER

SET @FACILITY_CODE = '$(varFacilityCode)'
SELECT @EIS_FACILITY_ID= E.PK_ENTITY, @FACILITY_UID = E.IDENTIFIER
FROM $(varBMS_EIS).dbo.ENTITY AS E
	INNER JOIN $(varBMS_EIS).dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION 
	INNER JOIN $(varBMS_EIS).dbo.EHL7_UID AS F ON E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'

CREATE TABLE #WARDGROUP (NAME NVARCHAR(50), ID UNIQUEIDENTIFIER, PK INT)
CREATE TABLE #BEDS (PK INT, BED_NAME NVARCHAR(50), BED_UID UNIQUEIDENTIFIER, WARD_GROUP_NAME NVARCHAR(50), WARD_GROUP_UID UNIQUEIDENTIFIER,)

INSERT INTO #WARDGROUP(NAME, ID, PK)
SELECT DISTINCT O.NAME, E.IDENTIFIER, O.PFK_ORGANIZATION
FROM $(varBMS_EIS).[dbo].[EHL7_ORGANIZATION] AS O
INNER JOIN $(varBMS_EIS).dbo.ENTITY AS E ON E.PK_ENTITY = O.PFK_ORGANIZATION
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @EIS_FACILITY_ID


INSERT INTO #BEDS(PK, BED_NAME, BED_UID, WARD_GROUP_NAME, WARD_GROUP_UID)
SELECT DISTINCT BED.PFK_PLACE, BED.NAME, E.IDENTIFIER, WARD_GROUP.NAME, WARD_GROUP.ID
FROM $(varBMS_EIS).[dbo].[EHL7_PLACE] AS BED
INNER JOIN $(varBMS_EIS).[dbo].[ENTITY] AS E ON E.PK_ENTITY = BED.PFK_PLACE
INNER JOIN $(varBMS_EIS).[dbo].[EHL7_ROLE] AS R_BED ON R_BED.FK_PLAYER_ENTITY = BED.PFK_PLACE AND R_BED.[CLASS_CODE] = 'MNT'
INNER JOIN #WARDGROUP AS WARD_GROUP ON WARD_GROUP.PK = R_BED.FK_SCOPER_ENTITY
WHERE BED.CODE_DISPLAY_NAME ='BED' 

;WITH DUPLICATE_BEDS (PK, BED_NAME)
AS
(
SELECT MAX(PK), BED_NAME
FROM #BEDS
GROUP BY BED_NAME
)

DELETE BED FROM #BEDS AS BED
LEFT OUTER JOIN DUPLICATE_BEDS AS DEL ON DEL.PK = BED.PK
WHERE DEL.PK IS NULL	

--delete from BMS databese
DELETE FROM $(varBMS).dbo.BED_STAFF WHERE FACILITY_UID = @FACILITY_UID
DELETE FROM $(varBMS_HISTORY).dbo.BED_STAFF_H WHERE FACILITY_UID = @FACILITY_UID

CREATE TABLE #STAFF(ROW_NO INT, ID INT, UPDATE_TRAIT_VALUE NVARCHAR(MAX))

;WITH S AS
(
	Select 	ROW_NUMBER() Over (Order By RecNum) AS ROW_NO,
	STAFF.RecNum AS ID,
	'exec $(varBMS_EIS).[dbo].[UPD_TRAIT_VALUE]
	 @ENTITY_IDENTIFIER= ''' + CONVERT(NVARCHAR(50), BED.BED_UID) + ''',
	 @DOMAIN_IDENTIFIER=N''InfoWorld'',
	 @ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',
	 @TRAIT_IDENTIFIER=N''NURSE_ASSIGNMENT'',
	 @TRAIT_VALUE_STRING=''' + REPLACE(STAFF.AssignedNur, '''', '''''') + ''',
	 @TRAIT_VALUE_REAL=NULL,
	 @TRAIT_VALUE_INTEGER=NULL,
	 @TRAIT_VALUE_DATETIME=NULL,
	 @TRAIT_VALUE_BYTE=NULL
	'+ CASE WHEN STAFF.AssignedNur <> '' THEN '
		 exec $(varBMS).[dbo].[usp_Insert_Bed_Staff]
		 @BED_UID= ''' + CONVERT(NVARCHAR(50), BED.BED_UID) + ''',
		 @DIVISION_UID=''' + CONVERT(NVARCHAR(50), BED.WARD_GROUP_UID) + ''', 
		 @STAFF= ''' + REPLACE(STAFF.AssignedNur, '''', '''''') + ''',
		 @PATIENT_UID=NULL,
		 @FACILITY_UID= ''' +CONVERT(NVARCHAR(50), @FACILITY_UID) + ''''
		ELSE '
		 exec $(varBMS).[dbo].[usp_Delete_Bed_Staff]
		 @BED_UID= ''' + CONVERT(NVARCHAR(50), BED.BED_UID) + ''''
	 END +'' AS  UPDATE_TRAIT_VALUE
	FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Whiteboard_Log] AS STAFF
	INNER JOIN #BEDS AS BED ON BED.BED_NAME = STAFF.VistaBed AND BED.WARD_GROUP_NAME = STAFF.Ward
	WHERE STAFF.AssignedNur IS NOT NULL AND STAFF.RecNum IN (SELECT MAX(RecNum) FROM $(varBMS_LOCAL_FACILITY).[dbo].[Bed_Control_Whiteboard_Log] GROUP BY VistaBed)	
)

INSERT INTO #STAFF(ROW_NO, ID, UPDATE_TRAIT_VALUE)
SELECT ROW_NO, ID, UPDATE_TRAIT_VALUE
FROM S
ORDER BY S.ID
DROP TABLE #BEDS
drop table #WARDGROUP

DECLARE @LAST_INDEX INT, @LAST_INDEX_PAGE INT, @LAST_INDEX_PREV INT, @PAGE_COUNT INT, @I INT
SET @PAGE_COUNT = 500
SET @I = 1
SET @LAST_INDEX_PAGE = 0
SET @LAST_INDEX_PREV = 0
SELECT @LAST_INDEX = MAX(ID) FROM #STAFF
WHILE (@LAST_INDEX_PAGE < @LAST_INDEX)
BEGIN
	SET @LAST_INDEX_PREV = @LAST_INDEX_PAGE
	SELECT @LAST_INDEX_PAGE = ID FROM #STAFF WHERE ROW_NO = @PAGE_COUNT*@I
	IF (@LAST_INDEX_PAGE = @LAST_INDEX_PREV)
		SELECT @LAST_INDEX_PAGE = MAX(ID) FROM #STAFF
SELECT @SQL = COALESCE(@SQL, '') + '
		'+  STAFF.UPDATE_TRAIT_VALUE +'
 '
FROM #STAFF  AS STAFF
WHERE STAFF.ID > @LAST_INDEX_PREV AND STAFF.ID <= @LAST_INDEX_PAGE
DELETE FROM #STAFF WHERE ID > @LAST_INDEX_PREV AND ID <= @LAST_INDEX_PAGE
SET @I = @I + 1
EXEC sp_executesql @SQL
SET @SQL = NULL
END 

DROP TABLE #STAFF


