﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.EIS;
using BMS.Facade.Data;
using FC = BMS.Facade.Data;
using BMS.Facade;
using VI = BMS.VistaIntegration.FacadeContracts;
using BMS.Utils;
using DC = BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using System.ServiceModel;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Mdws;
using BMS.VistaIntegration.Cache;
using BMS.VistaIntegration.Data;
using VIC = BMS.VistaIntegration.Data;
using BMS.ServicesWrapper.EVS;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using BMS.VistaWorker2.Writer;
using BMS.VistaWorker2.Writer.Implementation;
using System.IO;
using System.Reflection;
using System.Configuration;
using System.Data.SqlClient;
using System.Data;
using System.Threading;
using System.Xml;
using System.Xml.XPath;
using System.Xml.Serialization;

namespace Import_VistaJob
{
    public class PatientProcessor
    {
        static VI.VistASite vistaSettings = null;
        //static SqlConnection connection;

        public PatientProcessor(VI.VistASite _vistaSettings)
        {
            vistaSettings = _vistaSettings;
        }

        public static void ImportPatientsData(VI.VistASite vistaSite, string methodType)
        {
            vistaSettings = vistaSite;
            DataRetrievalMethod? retrievalMethod = null;
            bool _isSuccess = true;
            if (methodType.Equals(DataRetrievalMethod.MDWS.ToString(), StringComparison.InvariantCultureIgnoreCase))
                retrievalMethod = DataRetrievalMethod.MDWS;
            else if (methodType.Equals(DataRetrievalMethod.ODBC.ToString(), StringComparison.InvariantCultureIgnoreCase))
                retrievalMethod = DataRetrievalMethod.ODBC;
            try
            {
                Tracer.TraceMessage("Begin importPatientData");
                IVistAQuery query = Utils.GetVistASession(vistaSettings, retrievalMethod.Value).MakeQuery();
                IList<VIC.Patient> entries = null;
                int i = 0;
                do
                {
                    Tracer.TraceMessage("Begin getPage from VistA - page: " + i++);
                    entries = query.GetPatients(DateTime.MinValue, DateTime.Now.AddYears(1));
                    Tracer.TraceMessage("End getPage from VistA " + (entries != null ? entries.Count.ToString() : "0") + " entries");
                    if (entries != null && entries.Count > 0)
                    {
                        List<FC.Patient> patients = new List<FC.Patient>();
                        foreach (VIC.Patient patient in entries)
                            patients.Add(Utils.TranslatePatient(patient, vistaSettings));
                        InsertOrUpdatePatients(GetEntityXml(patients));
                    }
                    Tracer.TraceMessage("End processPage in BMS");
                }
                while (entries != null);
            }
            catch (FaultException<BMS.FaultContracts.VistAException> e)
            {
                _isSuccess = false;
                Tracer.TraceException(e);
                Console.WriteLine("ERROR: " + e.Detail.ErrorMessage);
            }
            finally
            {
                Utils.InsertVistaOperation(vistaSettings.Id, "2", DateTime.UtcNow);
                GlobalConnections.CloseConnections();
            }
            if (_isSuccess)
            {
                Tracer.TraceMessage("Process patients has finished.");
                Console.WriteLine("Process patients has finished.");
            }

        }

        public static void InsertOrUpdateIndividualPatient(VIC.Patient obj)
        {
            FC.Patient patient = Utils.TranslatePatient(obj, vistaSettings);
            if (patient == null || patient.SSN == null || string.IsNullOrEmpty(patient.SSN.extension))
                return;
            List<FC.Patient> list = new List<FC.Patient>();
            list.Add(patient);            
            InsertOrUpdatePatients(GetEntityXml(list));
        }

        private static void InsertOrUpdatePatients(string paramXml)
        {            
            using (SqlCommand cmd = new SqlCommand("INS_UPD_PATIENT_XML", GlobalConnections.EisConnection))
            {
                try
                {
                    cmd.CommandType = CommandType.StoredProcedure;
                    cmd.CommandTimeout = GlobalConnections.EisConnection.ConnectionTimeout;
                    cmd.Parameters.Add("@strXml", SqlDbType.Xml).Value = paramXml;
                    cmd.Parameters.Add("@vista_site_id", SqlDbType.NVarChar, 50).Value = vistaSettings.Id;
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException e)
                {
                    Tracer.TraceException(e);
                    throw;
                }
                finally
                {
                    cmd.Dispose();
                }
            }
        }

        private static string GetEntityXml(List<FC.Patient> list)
        {
            StringWriter stringWriter = new StringWriter();
            XmlDocument xmlDoc = new XmlDocument();
            XmlTextWriter xmlWriter = new XmlTextWriter(stringWriter);
            XmlSerializer serializer = new XmlSerializer(typeof(List<FC.Patient>));
            serializer.Serialize(xmlWriter, list);
            string res = stringWriter.ToString();
            res = res.Remove(0, res.IndexOf("<Patient"));
            res = res.Remove(res.LastIndexOf("</Patient>") + 10);
            return res;
        }

        //private static void CheckConnection()
        //{
        //    if (connection != null && (connection.State == ConnectionState.Broken || connection.State == ConnectionState.Closed))
        //    {
        //        connection.Dispose();
        //        connection = null;
        //    }
        //    if (connection == null)
        //    {
        //        connection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString);
        //        connection.Open();
        //    }
        //}
    }
}
