﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;

namespace Import_VistaJob
{
    public static class GlobalConnections
    {

        static SqlConnection bmsConnection;
        static SqlConnection eisConnection;

        public static SqlConnection BmsConnection
        {
            get
            {
                if (bmsConnection != null && (bmsConnection.State == ConnectionState.Broken || bmsConnection.State == ConnectionState.Closed))
                {
                    bmsConnection.Dispose();
                    bmsConnection = null;
                }
                if (bmsConnection == null)
                {
                    bmsConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMSDBConnString"].ConnectionString);
                    bmsConnection.Open();
                }
                return bmsConnection;
            }
            set 
            {
                bmsConnection = value;   
            }
        }

        public static SqlConnection EisConnection
        {
            get
            {
                if (eisConnection != null && (eisConnection.State == ConnectionState.Broken || eisConnection.State == ConnectionState.Closed))
                {
                    eisConnection.Dispose();
                    eisConnection = null;
                }
                if (eisConnection == null)
                {
                    eisConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["BMS_EISDBConnString"].ConnectionString);
                    eisConnection.Open();
                }
                return eisConnection;
            }
            set
            {
                eisConnection = value;
            }
        }

        public static void CloseConnections()
        {
            if (bmsConnection != null)
            {
                bmsConnection.Close();
                bmsConnection.Dispose();
            }
            if (eisConnection != null)
            {
                eisConnection.Close();
                eisConnection.Dispose();
            }
        }

    }
}
