﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Facade.Data;
using System.Data;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.EVS;
using InfoWorld.HL7.ITS;
using InfoWorld.EVS.CTSMAPI;
using BMS.Utils;
using BMS.Facade;
using DC = BMS.DataContracts;

namespace Import_Flows
{
    public class Translators
    {
        public const string DomainId = "InfoWorld";
        public const string PERSON_FIRST_NAME = "FirstName";
        public const string PERSON_MIDDLE_NAME = "MiddleName";
        public const string PERSON_LAST_NAME = "LastName";

        #region Translator Facility Waiting List

        public static List<WaitingListItem> TranslateWaitingListFromBMS(DataSet existingWaitingListItem, Facility facility, TimeZoneInfo facilityTimeZone)
        {
            List<WaitingListItem> result = new List<WaitingListItem>();
            WaitingListItem waitingListItem = null;
            foreach (DataRow dr in existingWaitingListItem.Tables[0].Rows)
            {
                waitingListItem = new WaitingListItem()
                {
                    Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["ACT_ID"].ToString()),
                    VistaSite = facility.VistaSite,
                    Facility = facility,
                    PatientId = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["PATIENT_UID"].ToString()),
                    CreationDate = (dr["CREATION_DATE"] == null || string.IsNullOrEmpty(dr["CREATION_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["CREATION_DATE"].ToString()),
                    RequestedDate = (dr["REQUESTED_BED_DATE"] == null || string.IsNullOrEmpty(dr["REQUESTED_BED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQUESTED_BED_DATE"].ToString()),
                    Problem = (dr["PROBLEM"] != null) ? dr["PROBLEM"].ToString() : null,
                    TypeOfBedWard = (dr["TYPE_OF_BED_WARD"] != null) ? dr["TYPE_OF_BED_WARD"].ToString() : null,
                    LastEditBy = (dr["LAST_EDIT_BY"] != null) ? dr["LAST_EDIT_BY"].ToString() : null,
                    WaitingArea = BuildConcept(dr["WAITING_AREA_CODE"].ToString(), dr["WAITING_AREA_CODE_SYSTEM"].ToString(), dr["WAITING_AREA_CODE_SYSTEM_NAME"].ToString(), dr["WAITING_AREA_DISPLAY_NAME"].ToString()),
                    FeeDisposition = BuildConcept(dr["FEE_DISPOSITION_CODE"].ToString(), dr["FEE_DISPOSITION_CODE_SYSTEM"].ToString(), dr["FEE_DISPOSITION_CODE_SYSTEM_NAME"].ToString(), dr["FEE_DISPOSITION_DISPLAY_NAME"].ToString()),
                    Authorization = BuildConcept(dr["AUTHORIZED_FEE_CODE"].ToString(), dr["AUTHORIZED_FEE_CODE_SYSTEM"].ToString(), dr["AUTHORIZED_FEE_CODE_SYSTEM_NAME"].ToString(), dr["AUTHORIZED_FEE_DISPLAY_NAME"].ToString()),
                    Contract = BuildConcept(dr["CONTRACT_FEE_CODE"].ToString(), dr["CONTRACT_FEE_CODE_SYSTEM"].ToString(), dr["CONTRACT_FEE_CODE_SYSTEM_NAME"].ToString(), dr["CONTRACT_FEE_DISPLAY_NAME"].ToString()),
                    ReasonFee = BuildConcept(dr["REASON_USING_FEE_CODE"].ToString(), dr["REASON_USING_FEE_CODE_SYSTEM"].ToString(), dr["REASON_USING_FEE_CODE_SYSTEM_NAME"].ToString(), dr["REASON_USING_FEE_DISPLAY_NAME"].ToString()),
                    CommentFee = (dr["FEE_COMMENTS"] != null) ? dr["FEE_COMMENTS"].ToString() : null,
                    RequestedBed = (dr["REQUESTED_BED_UID"] != null || string.IsNullOrEmpty(dr["REQUESTED_BED_UID"].ToString())) ? null : new Place() { Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["REQUESTED_BED_UID"].ToString()) },
                    RequestedBedDate = (dr["REQUESTED_BED_DATE"] == null || string.IsNullOrEmpty(dr["REQUESTED_BED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQUESTED_BED_DATE"].ToString()),
                    Parent = (dr["PARENT_ACT_ID"] == null || string.IsNullOrEmpty(dr["PARENT_ACT_ID"].ToString())) ? null : BuidParentId(dr["DOMAIN_ID"].ToString(), dr["PARENT_ACT_ID"].ToString()),
                    FlowId = Guid.Parse(dr["FLOW_ID"].ToString()),
                    IEN = (dr["IEN"] != null) ? dr["IEN"].ToString() : null
                };
                //TimeZoneUtil.ConvertObjectDates(waitingListItem, true, facilityTimeZone);
                result.Add(waitingListItem);
            }

            return result;
        }

        public static Dictionary<int, List<WaitingListItem>> TranslateToWaitingList(DataSet ds, Facility facility, TimeZoneInfo facilityTimeZone)
        {
            Dictionary<int, List<WaitingListItem>> result = new Dictionary<int, List<WaitingListItem>>();
            List<WaitingListItem> insertWaitingListItem = new List<WaitingListItem>();
            List<WaitingListItem> removeWaitingListItem = new List<WaitingListItem>();
            List<WaitingListItem> updateWaitingListItem = new List<WaitingListItem>();
            if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
            {
                List<CD> waitingAreaList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.WaitingArea.ToString() }).ToList();
                List<CD> dispositionList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.FeeDisposition.ToString() }).ToList();
                List<CD> contractList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.StrictDecision.ToString() }).ToList();
                List<CD> authorizationList = new List<CD>(contractList);
                List<CD> vistaSpecialitiesList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.VistaSpecialty.ToString() }).ToList();
                List<CD> feeList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.FeeReason.ToString() }).ToList();
                facility.VistaSite = EISFactory.InstanceWindows.GetVistaSite(facility.VistaSite.Id);
                List<Division> divisions = EISFactory.InstanceWindows.GetDivisions(facility.Id).ToList();
                List<Bed> beds = new List<Bed>();
                foreach (Division div in divisions)
                    beds.AddRange(EISFactory.InstanceWindows.GetBedsInDivision(div.Id, facility.VistaSite.Id));
                beds = GetDistinctBeds(beds);
                WaitingListItem wlItem = null;
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    wlItem = new WaitingListItem()
                    {
                        Id = new II(DomainId, null),
                        VistaSite = facility.VistaSite,
                        Facility = facility,
                        Patient = EISFactory.InstanceWindows.GetPatientBySsn(new II("SSN", GetSSN(dr["SSN"].ToString().Trim())), null),
                        CreationDate = (dr["EVENT_TIME"] == null || string.IsNullOrEmpty(dr["EVENT_TIME"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["EVENT_TIME"].ToString()),
                        RequestedDate = (dr["REQUEST_DT"] == null || string.IsNullOrEmpty(dr["REQUEST_DT"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQUEST_DT"].ToString()),
                        Problem = (dr["CURRENT_WARD"] != null) ? dr["CURRENT_WARD"].ToString() : null,
                        TypeOfBedWard = (dr["TYPE_OF_BED_REQUESTED"] != null) ? dr["TYPE_OF_BED_REQUESTED"].ToString() : null,
                        LastEditBy = (dr["RECORD_LAST_EDITED_BY"] != null) ? dr["RECORD_LAST_EDITED_BY"].ToString() : null,
                        WaitingArea = (dr["CURRENT_WAIT_AREA"] == null || string.IsNullOrEmpty(dr["CURRENT_WAIT_AREA"].ToString().Trim())) ? null : waitingAreaList.Where(a => a.displayName.Equals(dr["CURRENT_WAIT_AREA"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                        FeeDisposition = (dr["ACUTE"] == null || string.IsNullOrEmpty(dr["ACUTE"].ToString().Trim())) ? null : dispositionList.Where(a => a.displayName.Equals(dr["ACUTE"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                        Authorization = (dr["AUTHORIZED_FEE"] == null || string.IsNullOrEmpty(dr["AUTHORIZED_FEE"].ToString().Trim())) ? null : authorizationList.Where(a => a.displayName.Equals(dr["AUTHORIZED_FEE"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                        Contract = (dr["CONTRACTED"] == null || string.IsNullOrEmpty(dr["CONTRACTED"].ToString().Trim())) ? null : contractList.Where(a => a.displayName.Equals(dr["CONTRACTED"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                        ReasonFee = (dr["REASON_USING_FEE"] == null || string.IsNullOrEmpty(dr["REASON_USING_FEE"].ToString().Trim())) ? null : feeList.Where(a => a.displayName.Equals(dr["REASON_USING_FEE"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                        CommentFee = (dr["FEE_COMMENTS"] != null) ? dr["FEE_COMMENTS"].ToString() : null,
                    };

                    if (dr["ROOM_BED_ASSIGNED"] != null && !string.IsNullOrEmpty(dr["ROOM_BED_ASSIGNED"].ToString().Trim()))
                    {
                        Bed bed = beds.Where(a => a.Name.Equals(dr["ROOM_BED_ASSIGNED"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        if (bed != null)
                        {
                            wlItem.RequestedBed = new Place() { Id = bed.Id, Name = bed.Name };
                            wlItem.RequestedBedDate = (dr["BED_ASSIGNED_DT"] == null || string.IsNullOrEmpty(dr["BED_ASSIGNED_DT"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["BED_ASSIGNED_DT"].ToString());
                        }

                    }

                    if (dr["OPERATION"] != null && !string.IsNullOrEmpty(dr["OPERATION"].ToString().Trim()))
                    {
                        string operation = dr["OPERATION"].ToString();
                        switch (operation)
                        {
                            case "REMOVE":
                                {
                                    wlItem.RemovedDate = DateTime.Parse(dr["REMOVED_DATE"].ToString());
                                    TimeZoneUtil.ConvertObjectDates(wlItem, false, facilityTimeZone);
                                    removeWaitingListItem.Add(wlItem);
                                }
                                break;
                            case "UPDATE":
                                {
                                    TimeZoneUtil.ConvertObjectDates(wlItem, false, facilityTimeZone);
                                    updateWaitingListItem.Add(wlItem);
                                }
                                break;
                            default:
                                {
                                    TimeZoneUtil.ConvertObjectDates(wlItem, false, facilityTimeZone);
                                    insertWaitingListItem.Add(wlItem);
                                }
                                break;
                        }
                    }
                }
            }

            result.Add(1, insertWaitingListItem);
            result.Add(2, updateWaitingListItem);
            result.Add(3, removeWaitingListItem);
            return result;
        }

        #endregion

        #region Translator VISN Waiting List

        public static List<Transfer> TranslateTransferFromBMS(DataSet existingTransfers, Facility facility, TimeZoneInfo facilityTimeZone)
        {
            List<Transfer> result = new List<Transfer>();
            Transfer transfer = null;
            foreach (DataRow dr in existingTransfers.Tables[0].Rows)
            {
                transfer = new Transfer()
                {
                    Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["ACT_ID"].ToString()),
                    CanceledDate = (dr["CANCELED_DATE"] == null || string.IsNullOrEmpty(dr["CANCELED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["CANCELED_DATE"].ToString()),
                    CreationDate = (dr["CREATION_DATE"] == null || string.IsNullOrEmpty(dr["CREATION_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["CREATION_DATE"].ToString()),
                    FlowId = Guid.Parse(dr["FLOW_ID"].ToString()),
                    Parent = (dr["PARENT_ACT_ID"] == null || string.IsNullOrEmpty(dr["PARENT_ACT_ID"].ToString())) ? null : BuidParentId(dr["DOMAIN_ID"].ToString(), dr["PARENT_ACT_ID"].ToString()),
                    PatientId = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["PATIENT_UID"].ToString()),
                    Comment = (dr["REQ_COMMENTS"] != null) ? dr["REQ_COMMENTS"].ToString() : null,
                    Era = BuildConcept(dr["REQ_ERA_CODE"].ToString(), dr["REQ_ERA_CODE_SYSTEM"].ToString(), dr["REQ_ERA_CODE_SYSTEM_NAME"].ToString(), dr["REQ_ERA_DISPLAY_NAME"].ToString()),
                    FacilityFrom = facility,
                    Contract = BuildConcept(dr["REQ_CONTRACT_CODE"].ToString(), dr["REQ_CONTRACT_CODE_SYSTEM"].ToString(), dr["REQ_CONTRACT_CODE_SYSTEM_NAME"].ToString(), dr["REQ_CONTRACT_DISPLAY_NAME"].ToString()),
                    Diagnosis = (dr["REQ_DIAGNOSIS"] != null) ? dr["REQ_DIAGNOSIS"].ToString() : null,
                    CurrentLocation = (dr["REQ_CURRENT_LOCATION"] != null) ? dr["REQ_CURRENT_LOCATION"].ToString() : null,
                    Speciality = BuildConcept(dr["REQ_SPECIALITY_CODE"].ToString(), dr["REQ_SPECIALITY_CODE_SYSTEM"].ToString(), dr["REQ_SPECIALITY_CODE_SYSTEM_NAME"].ToString(), dr["REQ_SPECIALITY_DISPLAY_NAME"].ToString()),
                    AdmissionDate = (dr["REQ_LOCATION_ADMISSION_DATE"] == null || string.IsNullOrEmpty(dr["REQ_LOCATION_ADMISSION_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQ_LOCATION_ADMISSION_DATE"].ToString()),
                    RequestedDate = (dr["REQUESTED_DATE"] == null || string.IsNullOrEmpty(dr["REQUESTED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQUESTED_DATE"].ToString()),
                    IsNationalWaitList = false

                };
                //TimeZoneUtil.ConvertObjectDates(transfer, true, facilityTimeZone);
                result.Add(transfer);
            }

            return result;
        }

        public static Dictionary<int, List<Transfer>> TranslateToTransfer(DataSet ds, Facility facility, TimeZoneInfo facilityTimeZone)
        {
            Dictionary<int, List<Transfer>> result = new Dictionary<int, List<Transfer>>();
            List<Transfer> insertTransfers = new List<Transfer>();
            List<Transfer> updateTransfers = new List<Transfer>();
            List<Transfer> finalizeTransfers = new List<Transfer>();
            if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
            {
                List<CD> contractList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.StrictDecision.ToString() }).ToList();
                List<CD> eraList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.Era.ToString() }).ToList();
                List<CD> genderList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.Gender.ToString() }).ToList();
                List<CD> specialtyList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.VistaSpecialty.ToString() }).ToList();
                List<CD> dispositionList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.Disposition.ToString() }).ToList();
                Transfer transfer = null;
                Patient patient = null;
                string ssn = null;
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    if (dr["SSN"] != null && !string.IsNullOrEmpty(dr["SSN"].ToString().Trim()))
                    {
                        ssn = GetSSN(dr["SSN"].ToString().Trim());
                        patient = EISFactory.InstanceWindows.GetPatientBySsn(new II("SSN", ssn), null);
                        if (patient == null)
                        {
                            Dictionary<string, string> names = SplitPersonFullName(dr["PTNAME"].ToString().Trim());
                            patient = new Patient()
                            {
                                FirstName = names[PERSON_FIRST_NAME],
                                LastName = names[PERSON_LAST_NAME],
                                MiddleName = names[PERSON_MIDDLE_NAME],
                                SSN = new II("SSN", ssn),
                                Gender = (dr["GENDER"] == null || string.IsNullOrEmpty(dr["GENDER"].ToString().Trim())) ? null : genderList.Where(a => a.displayName.Equals(dr["GENDER"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                                IsVistaValidated = false,
                                ServiceConnectedPercentage = (dr["SERVCONN"] != null) ? dr["SERVCONN"].ToString().Trim() : null
                            };
                            EISFactory.InstanceWindows.CreatePatient(patient);
                            patient = EISFactory.InstanceWindows.GetPatientBySsn(new II("SSN", ssn), null);
                        }

                        transfer = new Transfer()
                        {
                            Id = new II(DomainId, null),
                            Comment = (dr["COMMENTS"] != null) ? dr["COMMENTS"].ToString() : null,
                            Contract = (dr["CONTRACT"] == null || string.IsNullOrEmpty(dr["CONTRACT"].ToString().Trim())) ? contractList.Where(a => a.displayName.Equals("NO", StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() : contractList.Where(a => a.displayName.Equals(dr["CONTRACT"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                            CreationDate = (dr["EVENTDT"] == null || string.IsNullOrEmpty(dr["EVENTDT"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["EVENTDT"].ToString()),
                            AdmissionDate = (dr["CHAdmitDT"] == null || string.IsNullOrEmpty(dr["CHAdmitDT"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["CHAdmitDT"].ToString()),
                            CurrentLocation = (dr["COMMHOSP"] != null) ? dr["COMMHOSP"].ToString() : null,
                            Diagnosis = (dr["DIAGNOSIS"] != null) ? dr["DIAGNOSIS"].ToString() : null,
                            Edited = (dr["LASTEDITDT"] == null || string.IsNullOrEmpty(dr["LASTEDITDT"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["LASTEDITDT"].ToString()),
                            EnteredBy = (dr["ENTEREDBY"] != null) ? dr["ENTEREDBY"].ToString() : null,
                            Era = (dr["ERA"] == null || string.IsNullOrEmpty(dr["ERA"].ToString().Trim())) ? eraList.Where(a => a.displayName.Equals("OTHER", StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() : eraList.Where(a => a.displayName.Equals(dr["ERA"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault(),
                            FacilityFrom = facility,
                            LastEditBy = (dr["LASTEDITBY"] != null) ? dr["LASTEDITBY"].ToString() : null,
                            Patient = patient,
                            RequestedDate = (dr["REQUESTDT"] == null || string.IsNullOrEmpty(dr["REQUESTDT"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQUESTDT"].ToString()),
                            Speciality = (dr["SPECNAMETEXT"] == null || string.IsNullOrEmpty(dr["SPECNAMETEXT"].ToString().Trim())) ? null : specialtyList.Where(a => a.displayName.Equals(dr["SPECNAMETEXT"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault()
                        };

                        if (dr["OPERATION"] != null && !string.IsNullOrEmpty(dr["OPERATION"].ToString().Trim()))
                        {

                            string operation = dr["OPERATION"].ToString();
                            switch (operation)
                            {
                                case "REMOVE":
                                    {
                                        transfer.DispositionDate = DateTime.Parse(dr["DISPDT"].ToString());
                                        transfer.DischargeComment = (dr["DCOMMENT"] != null) ? dr["DCOMMENT"].ToString() : null;
                                        transfer.Disposition = (dr["DISPOSITION"] == null || string.IsNullOrEmpty(dr["DISPOSITION"].ToString().Trim())) ? dispositionList.First() : dispositionList.Where(a => a.displayName.Equals(dr["DISPOSITION"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).First();
                                        transfer.FacilityTo = (dr["ADMITHOSP"] == null || string.IsNullOrEmpty(dr["ADMITHOSP"].ToString().Trim())) ? null : EISFactory.InstanceWindows.GetFacilityByCode(dr["ADMITHOSP"].ToString().Trim());
                                        TimeZoneUtil.ConvertObjectDates(transfer, false, facilityTimeZone);
                                        finalizeTransfers.Add(transfer);
                                    }
                                    break;
                                case "UPDATE":
                                    {
                                        TimeZoneUtil.ConvertObjectDates(transfer, false, facilityTimeZone);
                                        updateTransfers.Add(transfer);
                                    }
                                    break;
                                default:
                                    {
                                        TimeZoneUtil.ConvertObjectDates(transfer, false, facilityTimeZone);
                                        insertTransfers.Add(transfer);
                                    }
                                    break;
                            }
                        }
                    }
                }
            }
            result.Add(1, insertTransfers);
            result.Add(2, updateTransfers);
            result.Add(3, finalizeTransfers);
            return result;
        }

        #endregion

        #region Translator Bed Clean

        public static List<BedClean> TranslateBedClean(DataSet existingBedClean, TimeZoneInfo facilityTimeZone)
        {
            List<BedClean> result = new List<BedClean>();
            BedClean bedClean = null;
            foreach (DataRow dr in existingBedClean.Tables[0].Rows)
            {
                bedClean = new BedClean
                {
                    Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["ID"].ToString()),
                    Bed = new Bed() { Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["BED_UID"].ToString()) },
                    Ward = new Ward() { Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["WARD_UID"].ToString()) },
                    RequestedDate = (dr["REQUESTED_DATE"] == null || string.IsNullOrEmpty(dr["REQUESTED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["REQUESTED_DATE"].ToString()),
                    EventIen = (dr["IEN"] != null) ? dr["IEN"].ToString() : null
                };
                // TimeZoneUtil.ConvertObjectDates(bedClean, true, facilityTimeZone);
                result.Add(bedClean);
            }

            return result;
        }

        public static Dictionary<int, List<BedClean>> TranslateToBedClean(DataSet ds, Facility facility, List<Ward> wards, TimeZoneInfo facilityTimeZone)
        {
            Dictionary<int, List<BedClean>> result = new Dictionary<int, List<BedClean>>();
            List<BedClean> insertBedClean = new List<BedClean>();
            List<BedClean> updateBedClean = new List<BedClean>();
            if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
            {
                List<CD> manualReqList = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.StrictDecision.ToString() }).ToList();
                CD manualRequestYes = manualReqList.Where(a => a.displayName == "Yes").FirstOrDefault();
                CD manualRequestNo = manualReqList.Where(a => a.displayName == "No").FirstOrDefault();
                CD typeOfClean = EVSFactory.InstanceWindows.GetCodes(new CodeFilterParameters() { VocabularyDomain = Util.Vocabulary.Decision.ToString() }).ToList().Where(a => a.displayName == "Yes").FirstOrDefault();
                List<Division> divisions = EISFactory.InstanceWindows.GetDivisions(facility.Id).ToList();
                List<Bed> beds = new List<Bed>();
                foreach (Division div in divisions)
                    beds.AddRange(EISFactory.InstanceWindows.GetBedsInDivision(div.Id, facility.VistaSite.Id));
                beds = GetDistinctBeds(beds);
                BedClean bedClean = null;
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    Bed bed = null;
                    Ward ward = null;
                    bedClean = new BedClean()
                    {
                        Id = new II(DomainId, null),
                        RequestedDate = (dr["DTRequested"] == null || string.IsNullOrEmpty(dr["DTRequested"].ToString())) ? DateTime.UtcNow : DateTime.Parse(dr["DTRequested"].ToString()),
                        VacatedDate = (dr["DTVacated"] == null || string.IsNullOrEmpty(dr["DTVacated"].ToString())) ? DateTime.UtcNow : DateTime.Parse(dr["DTVacated"].ToString()),
                        AcceptedBy = (dr["AssignTo"] != null) ? dr["AssignTo"].ToString() : null,
                        AcceptedDate = (dr["DTAssigned"] == null || string.IsNullOrEmpty(dr["DTAssigned"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["DTAssigned"].ToString()),
                        EMSNotify = (dr["EMSNotify"] != null) ? dr["EMSNotify"].ToString() : null,
                        LastEditDate = (dr["DTLastEdit"] == null || string.IsNullOrEmpty(dr["DTLastEdit"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["DTLastEdit"].ToString()),
                        LastEditedBy = (dr["LastEditedBy"] != null) ? dr["LastEditedBy"].ToString() : null,
                        ManualRequest = (dr["ManRequest"] != null && !string.IsNullOrEmpty(dr["ManRequest"].ToString().Trim()) && dr["ManRequest"].ToString().Trim().Equals("Yes", StringComparison.InvariantCultureIgnoreCase)) ? manualRequestYes : manualRequestNo,
                        TypeOfClean = typeOfClean,
                        VistaSite = facility.VistaSite,
                        EventIen = (dr["RecNum"] != null) ? dr["RecNum"].ToString() : null,
                        CompletedBy = (dr["CompleteBy"] == null || string.IsNullOrEmpty(dr["CompleteBy"].ToString())) ? null : dr["CompleteBy"].ToString(),
                        CompletedDate = (dr["DTCompleted"] == null || string.IsNullOrEmpty(dr["DTCompleted"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["DTCompleted"].ToString()),
                    };
                    if (dr["Ward"] != null && !string.IsNullOrEmpty(dr["Ward"].ToString().Trim()))
                    {
                        ward = wards.Where(a => a.Name.Equals(dr["Ward"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        if (ward == null)
                        {
                            Tracer.TraceMessage("Ward not found. Bed clean IEN: " + bedClean.EventIen);
                            continue;
                        }
                        else
                            bedClean.Ward = ward;
                    }
                    else
                    {
                        Tracer.TraceMessage("Ward not found. Bed clean IEN: " + bedClean.EventIen);
                        continue;
                    }

                    if (dr["RmBed"] != null && !(string.IsNullOrEmpty(dr["RmBed"].ToString().Trim())))
                    {
                        bed = beds.Where(a => a.Name.Equals(dr["RmBed"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        if (bed != null)
                            bedClean.Bed = new Place() { Id = bed.Id, Name = bed.Name };
                    }

                    if (bedClean.ManualRequest.code == manualRequestNo.code && !string.IsNullOrEmpty(bedClean.EventIen) && dr["OPERATION"].ToString() == "INSERT")
                    {
                        DataSet parent = DataQuery.EventType(facility.VistaSite.Id.extension, bedClean.EventIen, bedClean.Ward.Id.extension);
                        if (parent != null && parent.Tables.Count != 0 && parent.Tables[0].Rows.Count != 0)
                        {
                            DataRow parentRow = parent.Tables[0].Rows[0];
                            if (bed == null)
                            {
                                bed = beds.Where(a => a.Id.extension.Equals(parentRow["BED"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                                if (bed != null)
                                    bedClean.Bed = new Place() { Id = bed.Id, Name = bed.Name };
                                else
                                {
                                    Tracer.TraceMessage("Bed not found. Bed clean IEN: " + bedClean.EventIen);
                                    continue;
                                }
                            }
                            if (parentRow["EVENT_TYPE"] != null && !(string.IsNullOrEmpty(parentRow["EVENT_TYPE"].ToString().Trim())))
                                bedClean.EventType = parentRow["EVENT_TYPE"].ToString();
                            else
                            {
                                Tracer.TraceMessage("Event type not found. Bed clean IEN: " + bedClean.EventIen);
                                continue;
                            }

                            if (parentRow["BED_CLEAN_ALREADY_EXISTS"] != null && !(string.IsNullOrEmpty(parentRow["BED_CLEAN_ALREADY_EXISTS"].ToString().Trim())) && parentRow["BED_CLEAN_ALREADY_EXISTS"].ToString().Trim() == "TRUE")
                            {
                                Tracer.TraceMessage("Bed clean with IEN " + bedClean.EventIen + " already exists in Bed clean table.");
                                continue;
                            }
                        }
                    }

                    if (bedClean.ManualRequest.code == manualRequestYes.code)
                    {
                        bedClean.EventIen = null;
                    }

                    if (bed != null)
                    {
                        TimeZoneUtil.ConvertObjectDates(bedClean, false, facilityTimeZone);
                        if (dr["OPERATION"].ToString() == "INSERT")
                            insertBedClean.Add(bedClean);
                        else
                            updateBedClean.Add(bedClean);
                    }
                    else
                    {
                        Tracer.TraceMessage("Bed not found. Bed clean IEN: " + bedClean.EventIen);
                    }
                }
            }
            result.Add(1, insertBedClean);
            result.Add(2, updateBedClean);
            return result;
        }

        #endregion

        #region Translator Bed Unavailable

        public static List<BedUnavailable> TranslateBedUnavailableLastInformation(DataSet bedUnavailableLastInformationDataSet, List<Bed> beds, List<CDWithProperties> reasonList, List<CD> typeList, TimeZoneInfo facilityTimeZone)
        {
            List<BedUnavailable> result = new List<BedUnavailable>();
            BedUnavailable bedUnavailable = null;
            beds = GetDistinctBeds(beds);
            Bed bed = null;
            foreach (DataRow dr in bedUnavailableLastInformationDataSet.Tables[0].Rows)
            {
                bed = beds.Where(a => a.Name.Equals(dr["BED_NAME"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                if (bed != null)
                {
                    bedUnavailable = new BedUnavailable()
                    {
                        Bed = new Place() { Id = bed.Id, Name = bed.Name },
                        EditedBy = (dr["EDIT_BY"] == null || string.IsNullOrEmpty(dr["EDIT_BY"].ToString())) ? null : dr["EDIT_BY"].ToString(),
                        EditedDate = (dr["EDIT_DATE"] == null || string.IsNullOrEmpty(dr["EDIT_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["EDIT_DATE"].ToString()),
                        CanceledBy = (dr["COMPLETED_BY"] == null || string.IsNullOrEmpty(dr["COMPLETED_BY"].ToString())) ? null : dr["COMPLETED_BY"].ToString(),
                        CanceledDate = (dr["COMPLETED_DATE"] == null || string.IsNullOrEmpty(dr["COMPLETED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["COMPLETED_DATE"].ToString()),
                        OutOfServiceVistA = (dr["MUST_CLOSE_FLOW"] == null || string.IsNullOrEmpty(dr["MUST_CLOSE_FLOW"].ToString())) ? false : bool.Parse(dr["MUST_CLOSE_FLOW"].ToString()),
                        WardList = bed.WardList
                    };

                    if (!bedUnavailable.OutOfServiceVistA)
                    {
                        CDWithProperties reason = reasonList.Where(a => a.displayName.Equals(dr["REASON_DISPLAY_NAME"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        bedUnavailable.Reason = (reason == null) ? null : new CD() { code = reason.code, codeSystem = reason.codeSystem, codeSystemName = reason.codeSystemName, displayName = reason.displayName };
                        if (dr["TYPE_DISPLAY_NAME"] != null || !string.IsNullOrEmpty(dr["TYPE_DISPLAY_NAME"].ToString()) || dr["TYPE_DISPLAY_NAME"].ToString() != "CLEAR-ALL")
                            bedUnavailable.Type = (reason == null) ? null : typeList.Where(a => a.code == reason.Properties.Where(b => b.PropertyName.text == "Type").FirstOrDefault().PropertyValue.text).FirstOrDefault();
                    }
                    if (bedUnavailable.Bed != null)
                    {
                        TimeZoneUtil.ConvertObjectDates(bedUnavailable, false, facilityTimeZone);
                        result.Add(bedUnavailable);
                    }
                }
            }
            Tracer.TraceMessage("finish translate all modifications for existing bed unavailable");
            return result.Distinct().ToList();
        }

        public static List<BedUnavailable> TranslateBedUnavailable(DataSet bedUnavailableFromBMS, List<Bed> beds, TimeZoneInfo facilityTimeZone)
        {
            List<BedUnavailable> result = new List<BedUnavailable>();
            BedUnavailable bedUnavailable = null;
            beds = GetDistinctBeds(beds);
            Bed bed = null;
            foreach (DataRow dr in bedUnavailableFromBMS.Tables[0].Rows)
            {
                bed = beds.Where(a => a.Id.extension.Equals(dr["BED_UID"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                if (bed == null)
                    continue;
                bedUnavailable = new BedUnavailable()
                {

                    CanceledDate = (dr["CANCELED_DATE"] == null || string.IsNullOrEmpty(dr["CANCELED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["CANCELED_DATE"].ToString()),
                    CreationDate = (dr["CREATION_DATE"] == null || string.IsNullOrEmpty(dr["CREATION_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["CREATION_DATE"].ToString()),
                    Id = BuildIdentifier(dr["DOMAIN_ID"].ToString(), dr["ACT_ID"].ToString()),
                    Parent = (dr["PARENT_ACT_ID"] == null || string.IsNullOrEmpty(dr["PARENT_ACT_ID"].ToString())) ? null : BuidParentId(dr["DOMAIN_ID"].ToString(), dr["PARENT_ACT_ID"].ToString()),
                    FlowId = Guid.Parse(dr["FLOW_ID"].ToString()),
                    IEN = dr["IEN"].ToString(),
                    Type = BuildConcept(dr["TYPE_CODE"].ToString(), dr["TYPE_CODE_SYSTEM"].ToString(), dr["TYPE_CODE_SYSTEM_NAME"].ToString(), dr["TYPE_DISPLAY_NAME"].ToString()),
                    Reason = BuildConcept(dr["REASON_CODE"].ToString(), dr["REASON_CODE_SYSTEM"].ToString(), dr["REASON_CODE_SYSTEM_NAME"].ToString(), dr["REASON_DISPLAY_NAME"].ToString()),
                    Division = null,
                    Bed = new Place() { Id = bed.Id, Name = bed.Name },
                    CreatedBy = dr["CREATED_BY"].ToString(),
                    EditedBy = dr["EDITED_BY"].ToString(),
                    EditedDate = (dr["EDITED_DATE"] == null || string.IsNullOrEmpty(dr["EDITED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["EDITED_DATE"].ToString()),
                    CanceledBy = string.Empty,
                    OutOfServiceVistA = false,
                    WardList = bed.WardList,
                    ExpectedCompletedDate = (dr["EXPECTED_COMPLETED_DATE"] == null || string.IsNullOrEmpty(dr["EXPECTED_COMPLETED_DATE"].ToString())) ? (DateTime?)null : DateTime.Parse(dr["EXPECTED_COMPLETED_DATE"].ToString())
                };
                //TimeZoneUtil.ConvertObjectDates(bedUnavailable, true, facilityTimeZone);
                result.Add(bedUnavailable);
            }
            Tracer.TraceMessage("finish translate all bed unavailable that already exists in BMS");
            return result.Distinct().ToList();

        }

        public static List<BedUnavailable> TranslateToBedUnavailable(DataSet ds, VistaSite vistaSite, List<Bed> beds, List<Ward> wards, TimeZoneInfo facilityTimeZone, List<CDWithProperties> reasonList, List<CD> typeList)
        {
            List<BedUnavailable> result = new List<BedUnavailable>();
            beds = GetDistinctBeds(beds);
            if (ds != null && ds.Tables != null && ds.Tables.Count > 0)
            {
                Tracer.TraceMessage("loaded all EVS collections");
                BedUnavailable bedUnavailable = null;
                Bed bed = null;
                foreach (DataRow dr in ds.Tables[0].Rows)
                {
                    bedUnavailable = new BedUnavailable()
                    {
                        Id = new II(DomainId, null),
                        CreationDate = DateTime.UtcNow,
                        OutOfServiceVistA = false,
                        VistaSite = vistaSite
                    };
                    if (dr["UREASONTEXT"] == null || string.IsNullOrEmpty(dr["UREASONTEXT"].ToString().Trim()))
                    {
                        bedUnavailable.Reason = null;
                        bedUnavailable.Type = null;
                        bedUnavailable.Bed = null;
                        bedUnavailable.WardList = null;
                    }
                    else
                    {
                        CDWithProperties reason = reasonList.Where(a => a.displayName.Equals(dr["UREASONTEXT"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        bedUnavailable.Reason = (reason == null) ? null : new CD() { code = reason.code, codeSystem = reason.codeSystem, codeSystemName = reason.codeSystemName, displayName = reason.displayName };
                        bedUnavailable.Type = (reason == null) ? null : typeList.Where(a => a.code == reason.Properties.Where(b => b.PropertyName.text == "Type").FirstOrDefault().PropertyValue.text).FirstOrDefault();
                        bed = (dr["BED"] == null || string.IsNullOrEmpty(dr["BED"].ToString().Trim())) ? null : beds.Where(a => a.Name.Equals(dr["BED"].ToString().Trim(), StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        if (bed == null) // the bed/ward is not any more associated to any division
                            continue;
                        bedUnavailable.Bed = new Place() { Id = bed.Id, Name = bed.Name };
                        if (bed != null && bed.WardList != null && bed.WardList.Count > 0)
                        {
                            bedUnavailable.WardList = new List<Ward>();
                            foreach (Ward ward in bed.WardList)
                                bedUnavailable.WardList.Add(wards.Where(a => a.Id.extension.Equals(ward.Id.extension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault());
                        }
                    }
                    if (bedUnavailable.Bed != null && bed.Reason != null)
                    {
                        TimeZoneUtil.ConvertObjectDates(bedUnavailable, false, facilityTimeZone);
                        result.Add(bedUnavailable);
                    }
                }
            }
            Tracer.TraceMessage("finish translate to unav beds");
            return result;
        }

        #endregion

        #region Private Methods

        private static Act BuidParentId(string root, string extension)
        {
            Act parent = new Act();
            parent.Id = BuildIdentifier(root, extension);
            return parent;
        }

        private static II BuildIdentifier(string root, string extension)
        {

            if (string.IsNullOrEmpty(extension) || extension.Equals(Guid.Empty.ToString()))
                return null;
            II identifier = new II()
            {
                root = root,
                extension = extension
            };
            return identifier;

        }

        private static CD BuildConcept(string code, string codeSystem, string codeSystemName, string displayName)
        {

            if (string.IsNullOrEmpty(code) && string.IsNullOrEmpty(codeSystem) && string.IsNullOrEmpty(codeSystemName) && string.IsNullOrEmpty(displayName))
                return null;
            CD concept = new CD()
            {
                code = code,
                codeSystem = codeSystem,
                codeSystemName = codeSystemName,
                displayName = displayName
            };
            return concept;
        }

        private static string GetSSN(string ssn)
        {
            if (string.IsNullOrEmpty(ssn))
                return null;
            return ssn.Substring(0, 3) + "-" + ssn.Substring(3, 2) + "-" + ssn.Substring(5);
        }

        private static Dictionary<string, string> SplitPersonFullName(string fullName)
        {
            Dictionary<string, string> result = new Dictionary<string, string>();
            result.Add(PERSON_FIRST_NAME, string.Empty);
            result.Add(PERSON_MIDDLE_NAME, string.Empty);
            result.Add(PERSON_LAST_NAME, string.Empty);

            string firstName = string.Empty, lastName = string.Empty, middleName = string.Empty;

            fullName = fullName.Trim();

            try
            {
                string[] names = fullName.Split(',');

                lastName = names[0].Trim();
                firstName = names[1].Trim();
                names = firstName.Split(' ');
                if (names.Length == 2)
                {
                    firstName = names[0].Trim();
                    middleName = names[1].Trim();
                }
            }
            catch
            {
                lastName = fullName;
                firstName = string.Empty;
                middleName = string.Empty;
            }

            result[PERSON_FIRST_NAME] = firstName;
            result[PERSON_MIDDLE_NAME] = middleName;
            result[PERSON_LAST_NAME] = lastName;

            return result;
        }

        private static List<Bed> GetDistinctBeds(List<Bed> beds)
        {
            if (beds != null && beds.Count > 1)
            {

                var ids = (from bed in beds
                           group bed by bed.Name into g
                           select (from max_bed_id in g select Convert.ToInt32(max_bed_id.Ien)).Max());

                return (from bed in beds
                        where ids.Contains(Convert.ToInt32(bed.Ien))
                        select bed).ToList();
            }
            return beds;
        }

        #endregion
    }
}
