SELECT DISTINCT
			[A].[ID] AS ACT_ID,
			[A].[CREATION_DATE] AS CREATION_DATE,
			[A].[CANCELED_DATE] AS CANCELED_DATE,
			[A].[PARENT_ACT_ID] AS PARENT_ACT_ID,
			[A].[FLOW_ID] AS FLOW_ID,
			[A].[DOMAIN_ID] AS DOMAIN_ID,
			[A].[PATIENT_UID] AS PATIENT_UID,	
			NULL AS EVN_ADMISSION_FACILITY_UID,					
			[ERA].[CODE] AS REQ_ERA_CODE,
			[ERA].[CODE_SYSTEM] AS REQ_ERA_CODE_SYSTEM,
			[ERA].[CODE_SYSTEM_NAME] AS REQ_ERA_CODE_SYSTEM_NAME,
			[ERA].[DISPLAY_NAME] AS REQ_ERA_DISPLAY_NAME,
			[TR].[COMMENTS] AS REQ_COMMENTS,
			[CC].[CODE] AS REQ_CONTRACT_CODE,
			[CC].[CODE_SYSTEM] AS REQ_CONTRACT_CODE_SYSTEM,
			[CC].[CODE_SYSTEM_NAME] AS REQ_CONTRACT_CODE_SYSTEM_NAME,
			[CC].[DISPLAY_NAME] AS REQ_CONTRACT_DISPLAY_NAME,
			[TR].[DIAGNOSIS] AS REQ_DIAGNOSIS,
			[TR].[CURRENT_LOCATION] AS REQ_CURRENT_LOCATION,
			[REQSP].[CODE] AS REQ_SPECIALITY_CODE,
			[REQSP].[CODE_SYSTEM] AS REQ_SPECIALITY_CODE_SYSTEM,
			[REQSP].[CODE_SYSTEM_NAME] AS REQ_SPECIALITY_CODE_SYSTEM_NAME,
			[REQSP].[DISPLAY_NAME] AS REQ_SPECIALITY_DISPLAY_NAME,
			[TR].[LOCATION_ADMISSION_DATE] AS REQ_LOCATION_ADMISSION_DATE,
			[TR].[REQUESTED_DATE] AS REQUESTED_DATE
		FROM ACT A
			INNER JOIN TRANSFER_REQ TR ON A.ID = TR.ACT_ID			
			LEFT JOIN CONCEPT AS CC ON TR.CONTRACT_ID = CC.ID		
			LEFT JOIN CONCEPT AS ERA ON TR.ERA_ID = ERA.ID
			LEFT JOIN CONCEPT AS REQSP ON TR.SPECIALITY_ID = REQSP.ID
		WHERE [TR].[FACILITY_UID] = '@FACILITY_UID' AND TR.ACT_ID NOT IN (SELECT PARENT_ACT_ID FROM ACT WHERE ID IN (SELECT ACT_ID FROM TRANSFER_EVN) AND PARENT_ACT_ID IS NOT NULL) 