DECLARE @VISTA_CODE NVARCHAR(20), @VISTA_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @VISTA_CODE = '$(varVISTACode)'
		SELECT @VISTA_UID = E.IDENTIFIER
		FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
		WHERE O.NAME = @VISTA_CODE AND CODE_CODE ='VST'

		CREATE TABLE #PLACE(ID INT)
		INSERT INTO #PLACE(ID)
		SELECT P.PFK_PLACE FROM BMS_EIS.dbo.EHL7_PLACE P
		INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON P.PFK_PLACE = R.FK_PLAYER_ENTITY AND CLASS_CODE = 'OWN'
		INNER JOIN BMS_EIS.dbo.ENTITY AS VS ON R.FK_SCOPER_ENTITY = VS.PK_ENTITY
		WHERE  P.CODE_CODE = 'WRD' AND VS.IDENTIFIER = @VISTA_UID

		--DELETE ROLE
		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #PLACE AS DEL ON DEL.ID = ROL.FK_PLAYER_ENTITY

		DELETE ROL FROM BMS_EIS.dbo.EHL7_ROLE AS ROL
		INNER JOIN #PLACE AS DEL ON DEL.ID = ROL.FK_SCOPER_ENTITY

		--DELETE TRAIT
		DELETE TV FROM BMS_EIS.dbo.TRAIT_VALUE AS TV
		INNER JOIN #PLACE AS DEL ON DEL.ID = TV.FK_ENTITY
		
		--DELETE UID
		DELETE OUID FROM BMS_EIS.dbo.EHL7_UID AS OUID
		INNER JOIN #PLACE AS DEL ON DEL.ID = OUID.FK_ENTITY

		--DELETE PLACE
		DELETE P FROM BMS_EIS.dbo.EHL7_PLACE AS P
		INNER JOIN #PLACE AS DEL ON DEL.ID = P.PFK_PLACE

		--DELETE ENTITY
		DELETE E FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN #PLACE AS DEL ON DEL.ID = E.PK_ENTITY
		DROP TABLE #PLACE

		DELETE FROM BMS.dbo.VISTA_OPERATIONS WHERE VISTA_ID = @VISTA_UID AND OPERATION_ID = 8
	SELECT 'Ward Location - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;



